/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import jakarta.servlet.ServletException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ProblemDetail;
import org.springframework.web.ErrorResponse;

public class NoHandlerFoundException
extends ServletException
implements ErrorResponse {
    private final String httpMethod;
    private final String requestURL;
    private final HttpHeaders headers;
    private final ProblemDetail body;

    public NoHandlerFoundException(String httpMethod, String requestURL, HttpHeaders headers) {
        super("No endpoint " + httpMethod + " " + requestURL + ".");
        this.httpMethod = httpMethod;
        this.requestURL = requestURL;
        this.headers = headers;
        this.body = ProblemDetail.forRawStatusCode((int)this.getRawStatusCode()).withDetail(this.getMessage());
    }

    public int getRawStatusCode() {
        return HttpStatus.NOT_FOUND.value();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public ProblemDetail getBody() {
        return this.body;
    }
}

