/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringProperties;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

public class RouterFunctionMapping
extends AbstractHandlerMapping
implements InitializingBean {
    private static final boolean shouldIgnoreXml = SpringProperties.getFlag((String)"spring.xml.ignore");
    @Nullable
    private RouterFunction<?> routerFunction;
    private List<HttpMessageConverter<?>> messageConverters = Collections.emptyList();
    private boolean detectHandlerFunctionsInAncestorContexts = false;

    public RouterFunctionMapping() {
        this.setPatternParser(new PathPatternParser());
    }

    public RouterFunctionMapping(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    public void setRouterFunction(@Nullable RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    @Nullable
    public RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setDetectHandlerFunctionsInAncestorContexts(boolean detectHandlerFunctionsInAncestorContexts) {
        this.detectHandlerFunctionsInAncestorContexts = detectHandlerFunctionsInAncestorContexts;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.routerFunction == null) {
            this.initRouterFunction();
        }
        if (CollectionUtils.isEmpty(this.messageConverters)) {
            this.initMessageConverters();
        }
    }

    private void initRouterFunction() {
        ApplicationContext applicationContext = this.obtainApplicationContext();
        Map beans = this.detectHandlerFunctionsInAncestorContexts ? BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, RouterFunction.class) : applicationContext.getBeansOfType(RouterFunction.class);
        ArrayList routerFunctions = new ArrayList(beans.values());
        if (!CollectionUtils.isEmpty(routerFunctions) && this.logger.isInfoEnabled()) {
            routerFunctions.forEach(routerFunction -> this.logger.info((Object)("Mapped " + routerFunction)));
        }
        this.routerFunction = routerFunctions.stream().reduce(RouterFunction::andOther).orElse(null);
    }

    private void initMessageConverters() {
        ArrayList messageConverters = new ArrayList(4);
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        if (!shouldIgnoreXml) {
            try {
                messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
            }
            catch (Error error) {
                // empty catch block
            }
        }
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        this.messageConverters = messageConverters;
    }

    @Override
    @Nullable
    protected Object getHandlerInternal(HttpServletRequest servletRequest) throws Exception {
        if (this.routerFunction != null) {
            ServerRequest request = ServerRequest.create(servletRequest, this.messageConverters);
            servletRequest.setAttribute(RouterFunctions.REQUEST_ATTRIBUTE, (Object)request);
            return this.routerFunction.route(request).orElse(null);
        }
        return null;
    }
}

