/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import javax.servlet.ServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.AbstractDelegatingCallable;
import org.springframework.web.context.request.async.AsyncExecutionChain;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.View;

public class ServletInvocableHandlerMethod
extends InvocableHandlerMethod {
    private HttpStatus responseStatus;
    private String responseReason;
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;

    public ServletInvocableHandlerMethod(Object handler, Method method) {
        super(handler, method);
        ResponseStatus annotation = (ResponseStatus)this.getMethodAnnotation(ResponseStatus.class);
        if (annotation != null) {
            this.responseStatus = annotation.value();
            this.responseReason = annotation.reason();
        }
    }

    public void setHandlerMethodReturnValueHandlers(HandlerMethodReturnValueHandlerComposite returnValueHandlers) {
        this.returnValueHandlers = returnValueHandlers;
    }

    public final void invokeAndHandle(ServletWebRequest webRequest, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        AsyncExecutionChain chain = AsyncExecutionChain.getForCurrentRequest((ServletRequest)webRequest.getRequest());
        chain.addDelegatingCallable(this.geAsyncCallable(webRequest, mavContainer, providedArgs));
        Object returnValue = this.invokeForRequest((NativeWebRequest)webRequest, mavContainer, providedArgs);
        this.setResponseStatus(webRequest);
        if (returnValue == null) {
            if (this.isRequestNotModified(webRequest) || this.hasResponseStatus() || mavContainer.isRequestHandled()) {
                mavContainer.setRequestHandled(true);
                return;
            }
        } else if (StringUtils.hasText((String)this.responseReason)) {
            mavContainer.setRequestHandled(true);
            return;
        }
        mavContainer.setRequestHandled(false);
        try {
            this.returnValueHandlers.handleReturnValue(returnValue, this.getReturnValueType(returnValue), mavContainer, (NativeWebRequest)webRequest);
        }
        catch (Exception ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.getReturnValueHandlingErrorMessage("Error handling return value", returnValue), (Throwable)ex);
            }
            throw ex;
        }
    }

    private AbstractDelegatingCallable geAsyncCallable(final ServletWebRequest webRequest, final ModelAndViewContainer mavContainer, final Object ... providedArgs) {
        return new AbstractDelegatingCallable(){

            public Object call() throws Exception {
                mavContainer.setRequestHandled(false);
                new CallableHandlerMethod(this.getNextCallable()).invokeAndHandle(webRequest, mavContainer, providedArgs);
                return null;
            }
        };
    }

    private String getReturnValueHandlingErrorMessage(String message, Object returnValue) {
        StringBuilder sb = new StringBuilder(message);
        if (returnValue != null) {
            sb.append(" [type=" + returnValue.getClass().getName() + "] ");
        }
        sb.append("[value=" + returnValue + "]");
        return this.getDetailedErrorMessage(sb.toString());
    }

    private void setResponseStatus(ServletWebRequest webRequest) throws IOException {
        if (this.responseStatus == null) {
            return;
        }
        if (StringUtils.hasText((String)this.responseReason)) {
            webRequest.getResponse().sendError(this.responseStatus.value(), this.responseReason);
        } else {
            webRequest.getResponse().setStatus(this.responseStatus.value());
        }
        webRequest.getRequest().setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)this.responseStatus);
    }

    private boolean isRequestNotModified(ServletWebRequest webRequest) {
        return webRequest.isNotModified();
    }

    private boolean hasResponseStatus() {
        return this.responseStatus != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallableHandlerMethod
    extends ServletInvocableHandlerMethod {
        public CallableHandlerMethod(Callable<?> callable) {
            super(callable, ClassUtils.getMethod(callable.getClass(), (String)"call", (Class[])new Class[0]));
            this.setHandlerMethodReturnValueHandlers(ServletInvocableHandlerMethod.this.returnValueHandlers);
        }

        public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
            return (A)ServletInvocableHandlerMethod.this.getMethodAnnotation(annotationType);
        }
    }
}

