/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;

abstract class MvcNamespaceUtils {
    private static final String BEAN_NAME_URL_HANDLER_MAPPING = "org.springframework.web.servlet.handler.beanNameUrlHandlerMapping";
    private static final String VIEW_CONTROLLER_HANDLER_ADAPTER = "org.springframework.web.servlet.config.viewControllerHandlerAdapter";
    private static final String HTTP_REQUEST_HANDLER_ADAPTER = "org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter";

    MvcNamespaceUtils() {
    }

    public static void registerDefaultHandlerAdapters(ParserContext parserContext, Object source) {
        MvcNamespaceUtils.registerHttpRequestHandlerAdapter(parserContext, source);
        MvcNamespaceUtils.registerSimpleControllerHandlerAdapter(parserContext, source);
    }

    public static void registerBeanNameUrlHandlerMapping(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(BEAN_NAME_URL_HANDLER_MAPPING)) {
            RootBeanDefinition beanNameMappingDef = new RootBeanDefinition(BeanNameUrlHandlerMapping.class);
            beanNameMappingDef.setSource(source);
            beanNameMappingDef.setRole(2);
            beanNameMappingDef.getPropertyValues().add("order", (Object)2);
            parserContext.getRegistry().registerBeanDefinition(BEAN_NAME_URL_HANDLER_MAPPING, (BeanDefinition)beanNameMappingDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanNameMappingDef, BEAN_NAME_URL_HANDLER_MAPPING));
        }
    }

    public static void registerHttpRequestHandlerAdapter(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(HTTP_REQUEST_HANDLER_ADAPTER)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(HTTP_REQUEST_HANDLER_ADAPTER, (BeanDefinition)handlerAdapterDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, HTTP_REQUEST_HANDLER_ADAPTER));
        }
    }

    public static void registerSimpleControllerHandlerAdapter(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(VIEW_CONTROLLER_HANDLER_ADAPTER)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(SimpleControllerHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(VIEW_CONTROLLER_HANDLER_ADAPTER, (BeanDefinition)handlerAdapterDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, VIEW_CONTROLLER_HANDLER_ADAPTER));
        }
    }
}

