/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.condition.LogicalDisjunctionRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.RequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestMethodsRequestCondition
extends LogicalDisjunctionRequestCondition<RequestMethodRequestCondition>
implements Comparable<RequestMethodsRequestCondition> {
    private RequestMethodsRequestCondition(Collection<RequestMethodRequestCondition> conditions) {
        super(conditions);
    }

    RequestMethodsRequestCondition(RequestMethod ... methods) {
        this((Collection<RequestMethodRequestCondition>)RequestMethodsRequestCondition.parseConditions(Arrays.asList(methods)));
    }

    private static Set<RequestMethodRequestCondition> parseConditions(List<RequestMethod> methods) {
        LinkedHashSet<RequestMethodRequestCondition> conditions = new LinkedHashSet<RequestMethodRequestCondition>(methods.size());
        for (RequestMethod method : methods) {
            conditions.add(new RequestMethodRequestCondition(method));
        }
        return conditions;
    }

    public RequestMethodsRequestCondition() {
        this(Collections.emptySet());
    }

    public Set<RequestMethod> getMethods() {
        LinkedHashSet<RequestMethod> result = new LinkedHashSet<RequestMethod>();
        for (RequestMethodRequestCondition condition : this.getConditions()) {
            result.add(condition.getMethod());
        }
        return result;
    }

    @Override
    public int compareTo(RequestMethodsRequestCondition other) {
        return other.getConditions().size() - this.getConditions().size();
    }

    public RequestMethodsRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.match(request)) {
            return new RequestMethodsRequestCondition(RequestMethod.valueOf((String)request.getMethod()));
        }
        return null;
    }

    public RequestMethodsRequestCondition combine(RequestMethodsRequestCondition other) {
        LinkedHashSet<RequestMethodRequestCondition> conditions = new LinkedHashSet<RequestMethodRequestCondition>(this.getConditions());
        conditions.addAll(other.getConditions());
        return new RequestMethodsRequestCondition((Collection<RequestMethodRequestCondition>)conditions);
    }

    static class RequestMethodRequestCondition
    implements RequestCondition {
        private final RequestMethod method;

        RequestMethodRequestCondition(RequestMethod method) {
            this.method = method;
        }

        RequestMethod getMethod() {
            return this.method;
        }

        public boolean match(HttpServletRequest request) {
            RequestMethod method = RequestMethod.valueOf((String)request.getMethod());
            return this.method.equals((Object)method);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof RequestMethodRequestCondition) {
                RequestMethodRequestCondition other = (RequestMethodRequestCondition)obj;
                return this.method.equals((Object)other.method);
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

