/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.RequestMethodsRequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestConditionFactory {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCEPT_HEADER = "Accept";

    public static RequestMethodsRequestCondition parseMethods(RequestMethod ... methods) {
        return methods != null ? new RequestMethodsRequestCondition(methods) : new RequestMethodsRequestCondition();
    }

    public static ParamsRequestCondition parseParams(String ... params) {
        return params != null ? new ParamsRequestCondition(params) : new ParamsRequestCondition();
    }

    public static HeadersRequestCondition parseHeaders(String ... headers) {
        if (headers == null) {
            return new HeadersRequestCondition();
        }
        HeadersRequestCondition headersCondition = new HeadersRequestCondition(headers);
        LinkedHashSet<HeadersRequestCondition.HeaderRequestCondition> filteredConditions = new LinkedHashSet<HeadersRequestCondition.HeaderRequestCondition>(headersCondition.getConditions());
        Iterator iterator = filteredConditions.iterator();
        while (iterator.hasNext()) {
            HeadersRequestCondition.HeaderRequestCondition headerCondition = (HeadersRequestCondition.HeaderRequestCondition)iterator.next();
            if (!ACCEPT_HEADER.equalsIgnoreCase(headerCondition.name) && !CONTENT_TYPE_HEADER.equalsIgnoreCase(headerCondition.name)) continue;
            iterator.remove();
        }
        return new HeadersRequestCondition((Collection<HeadersRequestCondition.HeaderRequestCondition>)filteredConditions);
    }

    public static ConsumesRequestCondition parseConsumes(String ... consumes) {
        return new ConsumesRequestCondition(consumes);
    }

    public static ConsumesRequestCondition parseConsumes(String[] consumes, String[] headers) {
        boolean consumesHasDefaultValue;
        List<ConsumesRequestCondition.ConsumeRequestCondition> allConditions = RequestConditionFactory.parseContentTypeHeaders(headers);
        boolean headersHasContentType = !allConditions.isEmpty();
        boolean bl = consumesHasDefaultValue = consumes.length == 1 && consumes[0].equals("*/*");
        if (!headersHasContentType || !consumesHasDefaultValue) {
            String[] stringArray = consumes;
            int n = consumes.length;
            int n2 = 0;
            while (n2 < n) {
                String consume = stringArray[n2];
                allConditions.add(new ConsumesRequestCondition.ConsumeRequestCondition(consume));
                ++n2;
            }
        }
        return new ConsumesRequestCondition((Collection<ConsumesRequestCondition.ConsumeRequestCondition>)allConditions);
    }

    private static List<ConsumesRequestCondition.ConsumeRequestCondition> parseContentTypeHeaders(String[] headers) {
        ArrayList<ConsumesRequestCondition.ConsumeRequestCondition> conditions = new ArrayList<ConsumesRequestCondition.ConsumeRequestCondition>();
        HeadersRequestCondition headersCondition = new HeadersRequestCondition(headers);
        for (HeadersRequestCondition.HeaderRequestCondition headerCondition : headersCondition.getConditions()) {
            if (!CONTENT_TYPE_HEADER.equalsIgnoreCase(headerCondition.name)) continue;
            List mediaTypes = MediaType.parseMediaTypes((String)((String)headerCondition.value));
            for (MediaType mediaType : mediaTypes) {
                conditions.add(new ConsumesRequestCondition.ConsumeRequestCondition(mediaType, headerCondition.isNegated));
            }
        }
        return conditions;
    }

    public static ProducesRequestCondition parseProduces(String ... produces) {
        return new ProducesRequestCondition(produces);
    }

    public static ProducesRequestCondition parseProduces(String[] produces, String[] headers) {
        boolean producesHasDefaultValue;
        List<ProducesRequestCondition.ProduceRequestCondition> allConditions = RequestConditionFactory.parseAcceptHeaders(headers);
        boolean headersHasAccept = !allConditions.isEmpty();
        boolean bl = producesHasDefaultValue = produces.length == 1 && produces[0].equals("*/*");
        if (!headersHasAccept || !producesHasDefaultValue) {
            String[] stringArray = produces;
            int n = produces.length;
            int n2 = 0;
            while (n2 < n) {
                String produce = stringArray[n2];
                allConditions.add(new ProducesRequestCondition.ProduceRequestCondition(produce));
                ++n2;
            }
        }
        return new ProducesRequestCondition((Collection<ProducesRequestCondition.ProduceRequestCondition>)allConditions);
    }

    private static List<ProducesRequestCondition.ProduceRequestCondition> parseAcceptHeaders(String[] headers) {
        ArrayList<ProducesRequestCondition.ProduceRequestCondition> allConditions = new ArrayList<ProducesRequestCondition.ProduceRequestCondition>();
        HeadersRequestCondition headersCondition = new HeadersRequestCondition(headers);
        for (HeadersRequestCondition.HeaderRequestCondition headerCondition : headersCondition.getConditions()) {
            if (!ACCEPT_HEADER.equalsIgnoreCase(headerCondition.name)) continue;
            List mediaTypes = MediaType.parseMediaTypes((String)((String)headerCondition.value));
            for (MediaType mediaType : mediaTypes) {
                allConditions.add(new ProducesRequestCondition.ProduceRequestCondition(mediaType, headerCondition.isNegated));
            }
        }
        return allConditions;
    }
}

