/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.web.servlet.mvc.method.condition.RequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RequestConditionComposite<T extends RequestCondition>
implements RequestCondition {
    private final Set<T> conditions;

    protected RequestConditionComposite(Collection<T> conditions) {
        this.conditions = Collections.unmodifiableSet(new LinkedHashSet<T>(conditions));
    }

    protected Set<T> getConditions() {
        return this.conditions;
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass().equals(o.getClass())) {
            RequestConditionComposite other = (RequestConditionComposite)o;
            return this.conditions.equals(other.conditions);
        }
        return false;
    }

    public int hashCode() {
        return this.conditions.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        String infix = this.getToStringInfix();
        Iterator<T> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            RequestCondition condition = (RequestCondition)iterator.next();
            builder.append(condition.toString());
            if (!iterator.hasNext()) continue;
            builder.append(infix);
        }
        builder.append("]");
        return builder.toString();
    }

    protected abstract String getToStringInfix();
}

