/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.condition.MediaTypesRequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducesRequestCondition
extends MediaTypesRequestCondition<ProduceRequestCondition> {
    ProducesRequestCondition(Collection<ProduceRequestCondition> conditions) {
        super(conditions);
    }

    ProducesRequestCondition(String ... consumes) {
        this((Collection<ProduceRequestCondition>)ProducesRequestCondition.parseConditions(Arrays.asList(consumes)));
    }

    private static Set<ProduceRequestCondition> parseConditions(List<String> consumes) {
        LinkedHashSet<ProduceRequestCondition> conditions = new LinkedHashSet<ProduceRequestCondition>(consumes.size());
        for (String consume : consumes) {
            conditions.add(new ProduceRequestCondition(consume));
        }
        return conditions;
    }

    public ProducesRequestCondition() {
        this(Collections.emptySet());
    }

    public ProducesRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<ProduceRequestCondition> matchingConditions = new LinkedHashSet<ProduceRequestCondition>(this.getConditions());
        Iterator iterator = matchingConditions.iterator();
        while (iterator.hasNext()) {
            ProduceRequestCondition condition = (ProduceRequestCondition)iterator.next();
            if (condition.match(request)) continue;
            iterator.remove();
        }
        if (matchingConditions.isEmpty()) {
            return null;
        }
        return new ProducesRequestCondition((Collection<ProduceRequestCondition>)matchingConditions);
    }

    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return !other.isEmpty() ? other : this;
    }

    public int compareTo(ProducesRequestCondition other, List<MediaType> acceptedMediaTypes) {
        for (MediaType acceptedMediaType : acceptedMediaTypes) {
            ProduceRequestCondition otherCondition;
            ProduceRequestCondition thisCondition;
            int result;
            int otherIndex;
            int thisIndex = this.indexOfMediaType(acceptedMediaType);
            if (thisIndex != (otherIndex = other.indexOfMediaType(acceptedMediaType))) {
                return otherIndex - thisIndex;
            }
            if (thisIndex == -1 || otherIndex == -1 || (result = (thisCondition = (ProduceRequestCondition)this.getSortedConditions().get(thisIndex)).compareTo(otherCondition = (ProduceRequestCondition)other.getSortedConditions().get(otherIndex))) == 0) continue;
            return result;
        }
        return 0;
    }

    private int indexOfMediaType(MediaType mediaType) {
        List sortedConditions = this.getSortedConditions();
        int i = 0;
        while (i < sortedConditions.size()) {
            ProduceRequestCondition condition = (ProduceRequestCondition)sortedConditions.get(i);
            if (mediaType.includes(condition.getMediaType())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProduceRequestCondition
    extends MediaTypesRequestCondition.MediaTypeRequestCondition {
        ProduceRequestCondition(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        ProduceRequestCondition(String expression) {
            super(expression);
        }

        @Override
        protected boolean match(HttpServletRequest request, MediaType mediaType) {
            List<MediaType> acceptedMediaTypes = this.getAccept(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!mediaType.isCompatibleWith(acceptedMediaType)) continue;
                return true;
            }
            return false;
        }

        private List<MediaType> getAccept(HttpServletRequest request) {
            String acceptHeader = request.getHeader("Accept");
            if (StringUtils.hasLength((String)acceptHeader)) {
                return MediaType.parseMediaTypes((String)acceptHeader);
            }
            return Collections.singletonList(MediaType.ALL);
        }
    }
}

