/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.method.condition.AbstractNameValueCondition;
import org.springframework.web.servlet.mvc.method.condition.LogicalConjunctionRequestCondition;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamsRequestCondition
extends LogicalConjunctionRequestCondition<ParamRequestCondition>
implements Comparable<ParamsRequestCondition> {
    private ParamsRequestCondition(Collection<ParamRequestCondition> conditions) {
        super(conditions);
    }

    ParamsRequestCondition(String ... params) {
        this((Collection<ParamRequestCondition>)ParamsRequestCondition.parseConditions(Arrays.asList(params)));
    }

    private static Set<ParamRequestCondition> parseConditions(List<String> params) {
        LinkedHashSet<ParamRequestCondition> conditions = new LinkedHashSet<ParamRequestCondition>(params.size());
        for (String param : params) {
            conditions.add(new ParamRequestCondition(param));
        }
        return conditions;
    }

    public ParamsRequestCondition() {
        this(Collections.emptySet());
    }

    public ParamsRequestCondition getMatchingCondition(HttpServletRequest request) {
        return this.match(request) ? this : null;
    }

    public ParamsRequestCondition combine(ParamsRequestCondition other) {
        LinkedHashSet<ParamRequestCondition> conditions = new LinkedHashSet<ParamRequestCondition>(this.getConditions());
        conditions.addAll(other.getConditions());
        return new ParamsRequestCondition((Collection<ParamRequestCondition>)conditions);
    }

    @Override
    public int compareTo(ParamsRequestCondition other) {
        return other.getConditions().size() - this.getConditions().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParamRequestCondition
    extends AbstractNameValueCondition<String> {
        ParamRequestCondition(String expression) {
            super(expression);
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(HttpServletRequest request) {
            return WebUtils.hasSubmitParameter((ServletRequest)request, (String)this.name);
        }

        @Override
        protected boolean matchValue(HttpServletRequest request) {
            return ((String)this.value).equals(request.getParameter(this.name));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof ParamRequestCondition) {
                ParamRequestCondition other = (ParamRequestCondition)obj;
                return this.name.equals(other.name) && (this.value != null ? ((String)this.value).equals(other.value) : other.value == null) && this.isNegated == other.isNegated;
            }
            return false;
        }
    }
}

