/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.method.condition.LogicalDisjunctionRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.RequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MediaTypesRequestCondition<T extends MediaTypeRequestCondition>
extends LogicalDisjunctionRequestCondition<T> {
    private final List<T> sortedConditions;

    public MediaTypesRequestCondition(Collection<T> conditions) {
        super(conditions);
        this.sortedConditions = new ArrayList<T>(conditions);
        Collections.sort(this.sortedConditions);
    }

    protected List<T> getSortedConditions() {
        return this.sortedConditions;
    }

    public Set<MediaType> getMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (MediaTypeRequestCondition condition : this.getConditions()) {
            result.add(condition.getMediaType());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class MediaTypeRequestCondition
    implements RequestCondition,
    Comparable<MediaTypeRequestCondition> {
        private final MediaType mediaType;
        private final boolean isNegated;

        MediaTypeRequestCondition(MediaType mediaType, boolean negated) {
            this.mediaType = mediaType;
            this.isNegated = negated;
        }

        MediaTypeRequestCondition(String expression) {
            if (expression.startsWith("!")) {
                this.isNegated = true;
                expression = expression.substring(1);
            } else {
                this.isNegated = false;
            }
            this.mediaType = MediaType.parseMediaType((String)expression);
        }

        @Override
        public boolean match(HttpServletRequest request) {
            boolean match = this.match(request, this.mediaType);
            return !this.isNegated ? match : !match;
        }

        protected abstract boolean match(HttpServletRequest var1, MediaType var2);

        MediaType getMediaType() {
            return this.mediaType;
        }

        @Override
        public int compareTo(MediaTypeRequestCondition other) {
            return MediaType.SPECIFICITY_COMPARATOR.compare(this.getMediaType(), other.getMediaType());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass().equals(obj.getClass())) {
                MediaTypeRequestCondition other = (MediaTypeRequestCondition)obj;
                return this.mediaType.equals((Object)other.mediaType) && this.isNegated == other.isNegated;
            }
            return false;
        }

        public int hashCode() {
            return this.mediaType.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.isNegated) {
                builder.append('!');
            }
            builder.append(this.mediaType.toString());
            return builder.toString();
        }
    }
}

