/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.method.condition.AbstractNameValueCondition;
import org.springframework.web.servlet.mvc.method.condition.LogicalConjunctionRequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersRequestCondition
extends LogicalConjunctionRequestCondition<HeaderRequestCondition>
implements Comparable<HeadersRequestCondition> {
    HeadersRequestCondition(Collection<HeaderRequestCondition> conditions) {
        super(conditions);
    }

    HeadersRequestCondition(String ... headers) {
        this((Collection<HeaderRequestCondition>)HeadersRequestCondition.parseConditions((Collection<String>)Arrays.asList(headers)));
    }

    private static Set<HeaderRequestCondition> parseConditions(Collection<String> params) {
        LinkedHashSet<HeaderRequestCondition> conditions = new LinkedHashSet<HeaderRequestCondition>(params.size());
        for (String param : params) {
            conditions.add(new HeaderRequestCondition(param));
        }
        return conditions;
    }

    public HeadersRequestCondition() {
        this(Collections.emptySet());
    }

    public HeadersRequestCondition getMatchingCondition(HttpServletRequest request) {
        return this.match(request) ? this : null;
    }

    public HeadersRequestCondition combine(HeadersRequestCondition other) {
        LinkedHashSet<HeaderRequestCondition> conditions = new LinkedHashSet<HeaderRequestCondition>(this.getConditions());
        conditions.addAll(other.getConditions());
        return new HeadersRequestCondition((Collection<HeaderRequestCondition>)conditions);
    }

    @Override
    public int compareTo(HeadersRequestCondition other) {
        return other.getConditions().size() - this.getConditions().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HeaderRequestCondition
    extends AbstractNameValueCondition<String> {
        public HeaderRequestCondition(String expression) {
            super(expression);
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(HttpServletRequest request) {
            return request.getHeader(this.name) != null;
        }

        @Override
        protected boolean matchValue(HttpServletRequest request) {
            return ((String)this.value).equals(request.getHeader(this.name));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof HeaderRequestCondition) {
                HeaderRequestCondition other = (HeaderRequestCondition)obj;
                return this.name.equalsIgnoreCase(other.name) && (this.value != null ? ((String)this.value).equals(other.value) : other.value == null) && this.isNegated == other.isNegated;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = this.name.toLowerCase().hashCode();
            result = 31 * result + (this.value != null ? ((String)this.value).hashCode() : 0);
            result = 31 * result + (this.isNegated ? 1 : 0);
            return result;
        }
    }
}

