/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.condition.MediaTypesRequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumesRequestCondition
extends MediaTypesRequestCondition<ConsumeRequestCondition>
implements Comparable<ConsumesRequestCondition> {
    ConsumesRequestCondition(Collection<ConsumeRequestCondition> conditions) {
        super(conditions);
    }

    ConsumesRequestCondition(String ... consumes) {
        this((Collection<ConsumeRequestCondition>)ConsumesRequestCondition.parseConditions(Arrays.asList(consumes)));
    }

    private static Set<ConsumeRequestCondition> parseConditions(List<String> consumes) {
        LinkedHashSet<ConsumeRequestCondition> conditions = new LinkedHashSet<ConsumeRequestCondition>(consumes.size());
        for (String consume : consumes) {
            conditions.add(new ConsumeRequestCondition(consume));
        }
        return conditions;
    }

    public ConsumesRequestCondition() {
        this(Collections.emptySet());
    }

    public ConsumesRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<ConsumeRequestCondition> matchingConditions = new LinkedHashSet<ConsumeRequestCondition>(this.getConditions());
        Iterator iterator = matchingConditions.iterator();
        while (iterator.hasNext()) {
            ConsumeRequestCondition condition = (ConsumeRequestCondition)iterator.next();
            if (condition.match(request)) continue;
            iterator.remove();
        }
        if (matchingConditions.isEmpty()) {
            return null;
        }
        return new ConsumesRequestCondition((Collection<ConsumeRequestCondition>)matchingConditions);
    }

    public ConsumesRequestCondition combine(ConsumesRequestCondition other) {
        return !other.isEmpty() ? other : this;
    }

    @Override
    public int compareTo(ConsumesRequestCondition other) {
        MediaTypesRequestCondition.MediaTypeRequestCondition thisMostSpecificCondition = this.getMostSpecificCondition();
        MediaTypesRequestCondition.MediaTypeRequestCondition otherMostSpecificCondition = other.getMostSpecificCondition();
        if (thisMostSpecificCondition == null && otherMostSpecificCondition == null) {
            return 0;
        }
        if (thisMostSpecificCondition == null) {
            return 1;
        }
        if (otherMostSpecificCondition == null) {
            return -1;
        }
        return thisMostSpecificCondition.compareTo(otherMostSpecificCondition);
    }

    private MediaTypesRequestCondition.MediaTypeRequestCondition getMostSpecificCondition() {
        if (!this.isEmpty()) {
            return (MediaTypesRequestCondition.MediaTypeRequestCondition)this.getSortedConditions().get(0);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConsumeRequestCondition
    extends MediaTypesRequestCondition.MediaTypeRequestCondition {
        ConsumeRequestCondition(String expression) {
            super(expression);
        }

        ConsumeRequestCondition(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        @Override
        protected boolean match(HttpServletRequest request, MediaType mediaType) {
            MediaType contentType = this.getContentType(request);
            return mediaType.includes(contentType);
        }

        private MediaType getContentType(HttpServletRequest request) {
            if (StringUtils.hasLength((String)request.getContentType())) {
                return MediaType.parseMediaType((String)request.getContentType());
            }
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }
}

