/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.condition;

import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.method.condition.RequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNameValueCondition<T>
implements RequestCondition {
    protected final String name;
    protected final T value;
    protected final boolean isNegated;

    AbstractNameValueCondition(String expression) {
        int separator = expression.indexOf(61);
        if (separator == -1) {
            this.isNegated = expression.startsWith("!");
            this.name = this.isNegated ? expression.substring(1) : expression;
            this.value = null;
        } else {
            this.isNegated = separator > 0 && expression.charAt(separator - 1) == '!';
            this.name = this.isNegated ? expression.substring(0, separator - 1) : expression.substring(0, separator);
            this.value = this.parseValue(expression.substring(separator + 1));
        }
    }

    protected abstract T parseValue(String var1);

    @Override
    public final boolean match(HttpServletRequest request) {
        boolean isMatch = this.value != null ? this.matchValue(request) : this.matchName(request);
        return this.isNegated ? !isMatch : isMatch;
    }

    protected abstract boolean matchName(HttpServletRequest var1);

    protected abstract boolean matchValue(HttpServletRequest var1);

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.isNegated ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.value != null) {
            builder.append(this.name);
            if (this.isNegated) {
                builder.append('!');
            }
            builder.append('=');
            builder.append(this.value);
        } else {
            if (this.isNegated) {
                builder.append('!');
            }
            builder.append(this.name);
        }
        return builder.toString();
    }
}

