/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.View;

public class ViewMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter returnType) {
        Class type = returnType.getParameterType();
        return Void.TYPE.equals(type) || String.class.equals((Object)type) || View.class.isAssignableFrom(type);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            return;
        }
        if (returnValue instanceof String) {
            mavContainer.setViewName((String)returnValue);
        } else if (returnValue instanceof View) {
            mavContainer.setView(returnValue);
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

