/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation.support;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.support.AbstractMessageConverterMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.support.RequestBodyNotValidException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestResponseBodyMethodProcessor
extends AbstractMessageConverterMethodProcessor {
    public RequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestBody.class);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getMethodAnnotation(ResponseBody.class) != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object arg = this.readWithMessageConverters(webRequest, parameter, parameter.getParameterType());
        if (this.shouldValidate(parameter, arg)) {
            String argName = Conventions.getVariableNameForParameter((MethodParameter)parameter);
            WebDataBinder binder = binderFactory.createBinder(webRequest, arg, argName);
            binder.validate();
            BindingResult errors = binder.getBindingResult();
            if (errors.hasErrors()) {
                throw new RequestBodyNotValidException((Errors)errors);
            }
        }
        return arg;
    }

    protected boolean shouldValidate(MethodParameter parameter, Object argumentValue) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = parameter.getParameterAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if ("Valid".equals(annot.annotationType().getSimpleName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
        mavContainer.setResolveView(false);
        if (returnValue != null) {
            this.writeWithMessageConverters(returnValue, returnType, webRequest);
        }
    }
}

