/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation.support;

import java.util.Map;
import javax.servlet.ServletException;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.support.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;

public class PathVariableMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public PathVariableMethodArgumentResolver() {
        super(null);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(PathVariable.class);
    }

    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        PathVariable annotation = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        return new PathVariableNamedValueInfo(annotation);
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        String key = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        int scope = 0;
        Map uriTemplateVars = (Map)request.getAttribute(key, scope);
        return uriTemplateVars != null ? (String)uriTemplateVars.get(name) : null;
    }

    protected void handleMissingValue(String name, MethodParameter parameter) throws ServletException {
        throw new IllegalStateException("Could not find the URL template variable [" + name + "]");
    }

    protected void handleResolvedValue(Object arg, String name, MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) {
        if (mavContainer != null) {
            mavContainer.addAttribute(name, arg);
        }
    }

    private static class PathVariableNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private PathVariableNamedValueInfo(PathVariable annotation) {
            super(annotation.value(), true, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }
    }
}

