/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation.support;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelFactory;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final List<ModelAndViewResolver> mavResolvers;

    public DefaultMethodReturnValueHandler() {
        this(null);
    }

    public DefaultMethodReturnValueHandler(List<ModelAndViewResolver> mavResolvers) {
        this.mavResolvers = mavResolvers;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return true;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest request) throws Exception {
        if (this.mavResolvers != null) {
            for (ModelAndViewResolver resolver : this.mavResolvers) {
                ExtendedModelMap model;
                Class handlerType = returnType.getDeclaringClass();
                Method method = returnType.getMethod();
                ModelAndView mav = resolver.resolveModelAndView(method, handlerType, returnValue, model = (ExtendedModelMap)mavContainer.getModel(), request);
                if (mav == ModelAndViewResolver.UNRESOLVED) continue;
                mavContainer.setView((Object)mav.getView());
                mavContainer.setViewName(mav.getViewName());
                mavContainer.addAllAttributes(mav.getModel());
                return;
            }
        }
        if (returnValue == null) {
            return;
        }
        if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
            String name = ModelFactory.getNameForReturnValue((Object)returnValue, (MethodParameter)returnType);
            mavContainer.addAttribute(name, returnValue);
            return;
        }
        throw new UnsupportedOperationException();
    }
}

