/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.method.annotation.InitBinderDataBinderFactory;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestDataBinderFactory
extends InitBinderDataBinderFactory {
    public ServletRequestDataBinderFactory(List<InvocableHandlerMethod> initBinderMethods, WebBindingInitializer bindingInitializer) {
        super(initBinderMethods, bindingInitializer);
    }

    public ServletRequestDataBinder createBinder(NativeWebRequest request, Object target, String objectName) throws Exception {
        return (ServletRequestDataBinder)super.createBinder(request, target, objectName);
    }

    protected WebDataBinder createBinderInstance(Object target, String objectName) {
        return new ServletRequestDataBinder(target, objectName){

            protected void doBind(MutablePropertyValues mpvs) {
                ServletRequestDataBinderFactory.this.addUriTemplateVariables(mpvs);
                super.doBind(mpvs);
            }
        };
    }

    protected void addUriTemplateVariables(MutablePropertyValues mpvs) {
        RequestAttributes requestAttrs = RequestContextHolder.getRequestAttributes();
        if (requestAttrs != null) {
            String key = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
            int scope = 0;
            Map uriTemplateVars = (Map)requestAttrs.getAttribute(key, scope);
            mpvs.addPropertyValues(uriTemplateVars);
        }
    }
}

