/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.condition.RequestConditionFactory;
import org.springframework.web.servlet.mvc.method.condition.RequestMethodsRequestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestMappingInfo {
    private final Set<String> patterns;
    private final RequestMethodsRequestCondition methodsCondition;
    private final ParamsRequestCondition paramsCondition;
    private final HeadersRequestCondition headersCondition;
    private final ConsumesRequestCondition consumesCondition;
    private final ProducesRequestCondition producesCondition;
    private int hash;

    RequestMappingInfo(Collection<String> patterns, RequestMethod[] methods) {
        this(patterns, RequestConditionFactory.parseMethods(methods), null, null, null, null);
    }

    public RequestMappingInfo(Collection<String> patterns, RequestMethodsRequestCondition methodsCondition, ParamsRequestCondition paramsCondition, HeadersRequestCondition headersCondition, ConsumesRequestCondition consumesCondition, ProducesRequestCondition producesCondition) {
        this.patterns = RequestMappingInfo.asUnmodifiableSet(RequestMappingInfo.prependLeadingSlash(patterns));
        this.methodsCondition = methodsCondition != null ? methodsCondition : new RequestMethodsRequestCondition();
        this.paramsCondition = paramsCondition != null ? paramsCondition : new ParamsRequestCondition();
        this.headersCondition = headersCondition != null ? headersCondition : new HeadersRequestCondition();
        this.consumesCondition = consumesCondition != null ? consumesCondition : new ConsumesRequestCondition();
        this.producesCondition = producesCondition != null ? producesCondition : new ProducesRequestCondition();
    }

    private static Set<String> prependLeadingSlash(Collection<String> patterns) {
        if (patterns == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(patterns.size());
        for (String pattern : patterns) {
            if (StringUtils.hasLength((String)pattern) && !pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            result.add(pattern);
        }
        return result;
    }

    private static <T> Set<T> asUnmodifiableSet(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(collection);
        return Collections.unmodifiableSet(result);
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    public RequestMethodsRequestCondition getMethods() {
        return this.methodsCondition;
    }

    public ParamsRequestCondition getParams() {
        return this.paramsCondition;
    }

    public HeadersRequestCondition getHeaders() {
        return this.headersCondition;
    }

    public ConsumesRequestCondition getConsumes() {
        return this.consumesCondition;
    }

    public ProducesRequestCondition getProduces() {
        return this.producesCondition;
    }

    public RequestMappingInfo combine(RequestMappingInfo methodKey, PathMatcher pathMatcher) {
        Set<String> patterns = RequestMappingInfo.combinePatterns(this.patterns, methodKey.patterns, pathMatcher);
        RequestMethodsRequestCondition methods = this.methodsCondition.combine(methodKey.methodsCondition);
        ParamsRequestCondition params = this.paramsCondition.combine(methodKey.paramsCondition);
        HeadersRequestCondition headers = this.headersCondition.combine(methodKey.headersCondition);
        ConsumesRequestCondition consumes = this.consumesCondition.combine(methodKey.consumesCondition);
        ProducesRequestCondition produces = this.producesCondition.combine(methodKey.producesCondition);
        return new RequestMappingInfo(patterns, methods, params, headers, consumes, produces);
    }

    private static Set<String> combinePatterns(Collection<String> typePatterns, Collection<String> methodPatterns, PathMatcher pathMatcher) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!typePatterns.isEmpty() && !methodPatterns.isEmpty()) {
            for (String pattern1 : typePatterns) {
                for (String pattern2 : methodPatterns) {
                    result.add(pathMatcher.combine(pattern1, pattern2));
                }
            }
        } else if (!typePatterns.isEmpty()) {
            result.addAll(typePatterns);
        } else if (!methodPatterns.isEmpty()) {
            result.addAll(methodPatterns);
        } else {
            result.add("");
        }
        return result;
    }

    public RequestMappingInfo getMatchingRequestMapping(String lookupPath, HttpServletRequest request, PathMatcher pathMatcher) {
        RequestMethodsRequestCondition matchingMethodCondition = this.methodsCondition.getMatchingCondition(request);
        ParamsRequestCondition matchingParamsCondition = this.paramsCondition.getMatchingCondition(request);
        HeadersRequestCondition matchingHeadersCondition = this.headersCondition.getMatchingCondition(request);
        ConsumesRequestCondition matchingConsumesCondition = this.consumesCondition.getMatchingCondition(request);
        ProducesRequestCondition matchingProducesCondition = this.producesCondition.getMatchingCondition(request);
        if (matchingMethodCondition == null || matchingParamsCondition == null || matchingHeadersCondition == null || matchingConsumesCondition == null || matchingProducesCondition == null) {
            return null;
        }
        List<String> matchingPatterns = this.getMatchingPatterns(lookupPath, pathMatcher);
        if (!matchingPatterns.isEmpty()) {
            return new RequestMappingInfo(matchingPatterns, matchingMethodCondition, matchingParamsCondition, matchingHeadersCondition, matchingConsumesCondition, matchingProducesCondition);
        }
        return null;
    }

    private List<String> getMatchingPatterns(String lookupPath, PathMatcher pathMatcher) {
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.patterns) {
            String matchingPattern = this.getMatchingPattern(pattern, lookupPath, pathMatcher);
            if (matchingPattern == null) continue;
            matchingPatterns.add(matchingPattern);
        }
        Collections.sort(matchingPatterns, pathMatcher.getPatternComparator(lookupPath));
        return matchingPatterns;
    }

    private String getMatchingPattern(String pattern, String lookupPath, PathMatcher pathMatcher) {
        boolean hasSuffix;
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        boolean bl = hasSuffix = pattern.indexOf(46) != -1;
        if (!hasSuffix && pathMatcher.match(String.valueOf(pattern) + ".*", lookupPath)) {
            return String.valueOf(pattern) + ".*";
        }
        if (pathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        boolean endsWithSlash = pattern.endsWith("/");
        if (!endsWithSlash && pathMatcher.match(String.valueOf(pattern) + "/", lookupPath)) {
            return String.valueOf(pattern) + "/";
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof RequestMappingInfo) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return this.patterns.equals(other.patterns) && this.methodsCondition.equals(other.methodsCondition) && this.paramsCondition.equals(other.paramsCondition) && this.headersCondition.equals(other.headersCondition) && this.consumesCondition.equals(other.consumesCondition) && this.producesCondition.equals(other.producesCondition);
        }
        return false;
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = this.patterns.hashCode();
            result = 31 * result + this.methodsCondition.hashCode();
            result = 31 * result + this.paramsCondition.hashCode();
            result = 31 * result + this.headersCondition.hashCode();
            result = 31 * result + this.consumesCondition.hashCode();
            this.hash = result = 31 * result + this.producesCondition.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append(this.patterns);
        builder.append(",methods=").append(this.methodsCondition);
        builder.append(",params=").append(this.paramsCondition);
        builder.append(",headers=").append(this.headersCondition);
        builder.append(",consumes=").append(this.consumesCondition);
        builder.append(",produces=").append(this.producesCondition);
        builder.append('}');
        return builder.toString();
    }
}

