/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.condition.RequestConditionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestMappingHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, Controller.class) != null;
    }

    @Override
    protected void handlerMethodsInitialized(Map<RequestMappingInfo, HandlerMethod> handlerMethods) {
        ArrayList mappings = new ArrayList(handlerMethods.keySet());
        while (mappings.size() > 1) {
            RequestMappingInfo cfr_ignored_0 = (RequestMappingInfo)mappings.remove(0);
            Iterator iterator = mappings.iterator();
            while (iterator.hasNext()) {
                RequestMappingInfo cfr_ignored_1 = (RequestMappingInfo)iterator.next();
            }
        }
    }

    @Override
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMapping annotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (annotation != null) {
            RequestMappingInfo methodMapping = RequestMappingHandlerMapping.createFromRequestMapping(annotation);
            RequestMapping typeAnnot = (RequestMapping)AnnotationUtils.findAnnotation(handlerType, RequestMapping.class);
            if (typeAnnot != null) {
                RequestMappingInfo typeMapping = RequestMappingHandlerMapping.createFromRequestMapping(typeAnnot);
                return typeMapping.combine(methodMapping, this.getPathMatcher());
            }
            return methodMapping;
        }
        return null;
    }

    private static RequestMappingInfo createFromRequestMapping(RequestMapping annotation) {
        return new RequestMappingInfo((Collection<String>)Arrays.asList(annotation.value()), RequestConditionFactory.parseMethods(annotation.method()), RequestConditionFactory.parseParams(annotation.params()), RequestConditionFactory.parseHeaders(annotation.headers()), RequestConditionFactory.parseConsumes(annotation.consumes(), annotation.headers()), RequestConditionFactory.parseProduces(annotation.produces(), annotation.headers()));
    }

    @Override
    protected Set<String> getMappingPaths(RequestMappingInfo mapping) {
        return mapping.getPatterns();
    }

    @Override
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo mapping, String lookupPath, HttpServletRequest request) {
        return mapping.getMatchingRequestMapping(lookupPath, request, this.getPathMatcher());
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(String lookupPath, HttpServletRequest request) {
        return new RequestMappingInfoComparator(lookupPath, request);
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, String lookupPath, HttpServletRequest request) {
        super.handleMatch(info, lookupPath, request);
        String pattern = info.getPatterns().iterator().next();
        Map uriTemplateVariables = this.getPathMatcher().extractUriTemplateVariables(pattern, lookupPath);
        request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, (Object)uriTemplateVariables);
        if (!info.getProduces().isEmpty()) {
            Set<MediaType> mediaTypes = info.getProduces().getMediaTypes();
            request.setAttribute(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    @Override
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        HashSet<String> allowedMethods = new HashSet<String>(6);
        HashSet<MediaType> consumableMediaTypes = new HashSet<MediaType>();
        HashSet<MediaType> producibleMediaTypes = new HashSet<MediaType>();
        for (RequestMappingInfo info : requestMappingInfos) {
            for (String pattern : info.getPatterns()) {
                if (!this.getPathMatcher().match(pattern, lookupPath)) continue;
                if (!info.getMethods().match(request)) {
                    for (RequestMethod method : info.getMethods().getMethods()) {
                        allowedMethods.add(method.name());
                    }
                }
                if (!info.getConsumes().match(request)) {
                    consumableMediaTypes.addAll(info.getConsumes().getMediaTypes());
                }
                if (info.getProduces().match(request)) continue;
                producibleMediaTypes.addAll(info.getProduces().getMediaTypes());
            }
        }
        if (!allowedMethods.isEmpty()) {
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), allowedMethods);
        }
        if (!consumableMediaTypes.isEmpty()) {
            MediaType contentType = null;
            if (StringUtils.hasLength((String)request.getContentType())) {
                contentType = MediaType.parseMediaType((String)request.getContentType());
            }
            throw new HttpMediaTypeNotSupportedException(contentType, new ArrayList(consumableMediaTypes));
        }
        if (!producibleMediaTypes.isEmpty()) {
            throw new HttpMediaTypeNotAcceptableException(new ArrayList(producibleMediaTypes));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestMappingInfoComparator
    implements Comparator<RequestMappingInfo> {
        private Comparator<String> patternComparator;
        private List<MediaType> requestAcceptHeader;

        public RequestMappingInfoComparator(String lookupPath, HttpServletRequest request) {
            this.patternComparator = RequestMappingHandlerMapping.this.getPathMatcher().getPatternComparator(lookupPath);
            String acceptHeader = request.getHeader("Accept");
            this.requestAcceptHeader = MediaType.parseMediaTypes((String)acceptHeader);
            MediaType.sortByQualityValue(this.requestAcceptHeader);
        }

        @Override
        public int compare(RequestMappingInfo mapping, RequestMappingInfo otherMapping) {
            int result = this.comparePatterns(mapping.getPatterns(), otherMapping.getPatterns());
            if (result != 0) {
                return result;
            }
            result = mapping.getParams().compareTo(otherMapping.getParams());
            if (result != 0) {
                return result;
            }
            result = mapping.getHeaders().compareTo(otherMapping.getHeaders());
            if (result != 0) {
                return result;
            }
            result = mapping.getConsumes().compareTo(otherMapping.getConsumes());
            if (result != 0) {
                return result;
            }
            result = mapping.getProduces().compareTo(otherMapping.getProduces(), this.requestAcceptHeader);
            if (result != 0) {
                return result;
            }
            result = mapping.getMethods().compareTo(otherMapping.getMethods());
            if (result != 0) {
                return result;
            }
            return 0;
        }

        private int comparePatterns(Set<String> patterns, Set<String> otherPatterns) {
            Iterator<String> iterator = patterns.iterator();
            Iterator<String> iteratorOther = otherPatterns.iterator();
            while (iterator.hasNext() && iteratorOther.hasNext()) {
                int result = this.patternComparator.compare(iterator.next(), iteratorOther.next());
                if (result == 0) continue;
                return result;
            }
            if (iterator.hasNext()) {
                return -1;
            }
            if (iteratorOther.hasNext()) {
                return 1;
            }
            return 0;
        }
    }
}

