/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.DefaultDataBinderFactory;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.HandlerMethodSelector;
import org.springframework.web.method.annotation.ModelFactory;
import org.springframework.web.method.annotation.SessionAttributesHandler;
import org.springframework.web.method.annotation.support.ErrorsMethodArgumentResolver;
import org.springframework.web.method.annotation.support.ExpressionValueMethodArgumentResolver;
import org.springframework.web.method.annotation.support.ModelAttributeMethodProcessor;
import org.springframework.web.method.annotation.support.ModelMethodProcessor;
import org.springframework.web.method.annotation.support.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.method.annotation.support.RequestHeaderMethodArgumentResolver;
import org.springframework.web.method.annotation.support.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.annotation.support.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;
import org.springframework.web.servlet.mvc.method.AbstractHandlerMethodAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestDataBinderFactory;
import org.springframework.web.servlet.mvc.method.annotation.support.DefaultMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.support.HttpEntityMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.support.ModelAndViewMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.support.PathVariableMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.support.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.support.ServletCookieValueMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.support.ServletModelAttributeMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.support.ServletRequestMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.support.ServletResponseMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.support.ViewMethodReturnValueHandler;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestMappingHandlerAdapter
extends AbstractHandlerMethodAdapter
implements BeanFactoryAware,
InitializingBean {
    private List<HandlerMethodArgumentResolver> customArgumentResolvers;
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers;
    private List<ModelAndViewResolver> modelAndViewResolvers;
    private List<HttpMessageConverter<?>> messageConverters;
    private WebBindingInitializer webBindingInitializer;
    private int cacheSecondsForSessionAttributeHandlers = 0;
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private ConfigurableBeanFactory beanFactory;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private final Map<Class<?>, SessionAttributesHandler> sessionAttributesHandlerCache = new ConcurrentHashMap();
    private final Map<Class<?>, Set<Method>> modelAttributeMethodCache = new ConcurrentHashMap();
    private final Map<Class<?>, Set<Method>> initBinderMethodCache = new ConcurrentHashMap();
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    private HandlerMethodArgumentResolverComposite initBinderArgumentResolvers;
    public static final ReflectionUtils.MethodFilter INIT_BINDER_METHODS = new ReflectionUtils.MethodFilter(){

        public boolean matches(Method method) {
            return AnnotationUtils.findAnnotation((Method)method, InitBinder.class) != null;
        }
    };
    public static final ReflectionUtils.MethodFilter MODEL_ATTRIBUTE_METHODS = new ReflectionUtils.MethodFilter(){

        public boolean matches(Method method) {
            return AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) == null && AnnotationUtils.findAnnotation((Method)method, ModelAttribute.class) != null;
        }
    };

    public RequestMappingHandlerAdapter() {
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.messageConverters = new ArrayList();
        this.messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new XmlAwareFormHttpMessageConverter());
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (argumentResolvers != null) {
            this.argumentResolvers = new HandlerMethodArgumentResolverComposite();
            this.argumentResolvers.addResolvers(argumentResolvers);
        }
    }

    public void setInitBinderArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (argumentResolvers != null) {
            this.initBinderArgumentResolvers = new HandlerMethodArgumentResolverComposite();
            this.initBinderArgumentResolvers.addResolvers(argumentResolvers);
        }
    }

    public void setCustomReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        this.customReturnValueHandlers = returnValueHandlers;
    }

    public void setReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        if (returnValueHandlers != null) {
            this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
            this.returnValueHandlers.addHandlers(returnValueHandlers);
        }
    }

    public void setModelAndViewResolvers(List<ModelAndViewResolver> modelAndViewResolvers) {
        this.modelAndViewResolvers = modelAndViewResolvers;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setCacheSecondsForSessionAttributeHandlers(int cacheSecondsForSessionAttributeHandlers) {
        this.cacheSecondsForSessionAttributeHandlers = cacheSecondsForSessionAttributeHandlers;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    public void afterPropertiesSet() {
        this.initArgumentResolvers();
        this.initReturnValueHandlers();
        this.initInitBinderArgumentResolvers();
    }

    private void initArgumentResolvers() {
        if (this.argumentResolvers == null) {
            this.argumentResolvers = new HandlerMethodArgumentResolverComposite();
        }
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(this.beanFactory, false));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new PathVariableMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletModelAttributeMethodProcessor(false));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestResponseBodyMethodProcessor(this.messageConverters));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(this.beanFactory));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletCookieValueMethodArgumentResolver(this.beanFactory));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ExpressionValueMethodArgumentResolver(this.beanFactory));
        this.argumentResolvers.addResolvers(this.customArgumentResolvers);
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletRequestMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletResponseMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new HttpEntityMethodProcessor(this.messageConverters));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ModelMethodProcessor());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ErrorsMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(this.beanFactory, true));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletModelAttributeMethodProcessor(true));
    }

    private void initInitBinderArgumentResolvers() {
        if (this.initBinderArgumentResolvers == null) {
            this.initBinderArgumentResolvers = new HandlerMethodArgumentResolverComposite();
        }
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(this.beanFactory, false));
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver());
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new PathVariableMethodArgumentResolver());
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new ExpressionValueMethodArgumentResolver(this.beanFactory));
        this.argumentResolvers.addResolvers(this.customArgumentResolvers);
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletRequestMethodArgumentResolver());
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new ServletResponseMethodArgumentResolver());
        this.initBinderArgumentResolvers.addResolver((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(this.beanFactory, true));
    }

    private void initReturnValueHandlers() {
        if (this.returnValueHandlers == null) {
            this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
        }
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new RequestResponseBodyMethodProcessor(this.messageConverters));
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new ModelAttributeMethodProcessor(false));
        this.returnValueHandlers.addHandlers(this.customReturnValueHandlers);
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new ModelAndViewMethodReturnValueHandler());
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new ModelMethodProcessor());
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new ViewMethodReturnValueHandler());
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new HttpEntityMethodProcessor(this.messageConverters));
        this.returnValueHandlers.addHandler((HandlerMethodReturnValueHandler)new DefaultMethodReturnValueHandler(this.modelAndViewResolvers));
    }

    @Override
    protected boolean supportsInternal(HandlerMethod handlerMethod) {
        return this.supportsMethodParameters(handlerMethod.getMethodParameters()) && this.supportsReturnType(handlerMethod.getReturnType());
    }

    private boolean supportsMethodParameters(MethodParameter[] methodParameters) {
        MethodParameter[] methodParameterArray = methodParameters;
        int n = methodParameters.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter methodParameter = methodParameterArray[n2];
            if (!this.argumentResolvers.supportsParameter(methodParameter)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean supportsReturnType(MethodParameter methodReturnType) {
        return this.returnValueHandlers.supportsReturnType(methodReturnType) || Void.TYPE.equals(methodReturnType.getParameterType());
    }

    @Override
    protected long getLastModifiedInternal(HttpServletRequest request, HandlerMethod handlerMethod) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ModelAndView handleInternal(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws Exception {
        HttpSession session;
        if (this.hasSessionAttributes(handlerMethod.getBeanType())) {
            this.checkAndPrepare(request, response, this.cacheSecondsForSessionAttributeHandlers, true);
        } else {
            this.checkAndPrepare(request, response, true);
        }
        if (this.synchronizeOnSession && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return this.invokeHandlerMethod(request, response, handlerMethod);
            }
        }
        return this.invokeHandlerMethod(request, response, handlerMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSessionAttributes(Class<?> handlerType) {
        SessionAttributesHandler handler = null;
        Map<Class<?>, SessionAttributesHandler> map = this.sessionAttributesHandlerCache;
        synchronized (map) {
            handler = this.sessionAttributesHandlerCache.get(handlerType);
            if (handler == null) {
                handler = new SessionAttributesHandler(handlerType, this.sessionAttributeStore);
                this.sessionAttributesHandlerCache.put(handlerType, handler);
            }
        }
        return handler.hasSessionAttributes();
    }

    private ModelAndView invokeHandlerMethod(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws Exception {
        WebDataBinderFactory binderFactory = this.createDataBinderFactory(handlerMethod);
        ModelFactory modelFactory = this.createModelFactory(handlerMethod, binderFactory);
        ServletInvocableHandlerMethod requestMethod = this.createRequestMappingMethod(handlerMethod, binderFactory);
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        SimpleSessionStatus sessionStatus = new SimpleSessionStatus();
        ModelAndViewContainer mavContainer = new ModelAndViewContainer();
        modelFactory.initModel((NativeWebRequest)webRequest, mavContainer, (HandlerMethod)requestMethod);
        requestMethod.invokeAndHandle((NativeWebRequest)webRequest, mavContainer, sessionStatus);
        modelFactory.updateModel((NativeWebRequest)webRequest, mavContainer, (SessionStatus)sessionStatus);
        if (!mavContainer.isResolveView()) {
            return null;
        }
        ModelAndView mav = new ModelAndView().addAllObjects((Map<String, ?>)mavContainer.getModel());
        mav.setViewName(mavContainer.getViewName());
        if (mavContainer.getView() != null) {
            mav.setView((View)mavContainer.getView());
        }
        return mav;
    }

    private WebDataBinderFactory createDataBinderFactory(HandlerMethod handlerMethod) {
        ArrayList<InvocableHandlerMethod> initBinderMethods = new ArrayList<InvocableHandlerMethod>();
        Class handlerType = handlerMethod.getBeanType();
        Set binderMethods = this.initBinderMethodCache.get(handlerType);
        if (binderMethods == null) {
            binderMethods = HandlerMethodSelector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS);
            this.initBinderMethodCache.put(handlerType, binderMethods);
        }
        for (Method method : binderMethods) {
            Object bean = handlerMethod.getBean();
            InvocableHandlerMethod binderMethod = new InvocableHandlerMethod(bean, method);
            binderMethod.setHandlerMethodArgumentResolvers(this.initBinderArgumentResolvers);
            binderMethod.setDataBinderFactory((WebDataBinderFactory)new DefaultDataBinderFactory(this.webBindingInitializer));
            binderMethod.setParameterNameDiscoverer(this.parameterNameDiscoverer);
            initBinderMethods.add(binderMethod);
        }
        return new ServletRequestDataBinderFactory(initBinderMethods, this.webBindingInitializer);
    }

    private ModelFactory createModelFactory(HandlerMethod handlerMethod, WebDataBinderFactory binderFactory) {
        ArrayList<InvocableHandlerMethod> modelAttrMethods = new ArrayList<InvocableHandlerMethod>();
        Class handlerType = handlerMethod.getBeanType();
        Set attributeMethods = this.modelAttributeMethodCache.get(handlerType);
        if (attributeMethods == null) {
            attributeMethods = HandlerMethodSelector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS);
            this.modelAttributeMethodCache.put(handlerType, attributeMethods);
        }
        for (Method method : attributeMethods) {
            InvocableHandlerMethod attrMethod = new InvocableHandlerMethod(handlerMethod.getBean(), method);
            attrMethod.setHandlerMethodArgumentResolvers(this.argumentResolvers);
            attrMethod.setDataBinderFactory(binderFactory);
            attrMethod.setParameterNameDiscoverer(this.parameterNameDiscoverer);
            modelAttrMethods.add(attrMethod);
        }
        return new ModelFactory(modelAttrMethods, binderFactory, this.sessionAttributesHandlerCache.get(handlerType));
    }

    private ServletInvocableHandlerMethod createRequestMappingMethod(HandlerMethod handlerMethod, WebDataBinderFactory binderFactory) {
        Method method = handlerMethod.getMethod();
        ServletInvocableHandlerMethod requestMethod = new ServletInvocableHandlerMethod(handlerMethod.getBean(), method);
        requestMethod.setHandlerMethodArgumentResolvers(this.argumentResolvers);
        requestMethod.setHandlerMethodReturnValueHandlers(this.returnValueHandlers);
        requestMethod.setDataBinderFactory(binderFactory);
        requestMethod.setParameterNameDiscoverer(this.parameterNameDiscoverer);
        return requestMethod;
    }
}

