/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.HandlerMethodSelector;
import org.springframework.web.method.annotation.ExceptionMethodMapping;
import org.springframework.web.method.annotation.support.ModelAttributeMethodProcessor;
import org.springframework.web.method.annotation.support.ModelMethodProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerMethodExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.support.DefaultMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.support.HttpEntityMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.support.ModelAndViewMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.support.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.support.ServletRequestMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.support.ServletResponseMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.support.ViewMethodReturnValueHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerExceptionResolver
extends AbstractHandlerMethodExceptionResolver
implements InitializingBean {
    private List<HandlerMethodArgumentResolver> customArgumentResolvers;
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers;
    private List<HttpMessageConverter<?>> messageConverters;
    private final Map<Class<?>, ExceptionMethodMapping> exceptionMethodMappingCache = new ConcurrentHashMap();
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;
    public static ReflectionUtils.MethodFilter EXCEPTION_HANDLER_METHODS = new ReflectionUtils.MethodFilter(){

        public boolean matches(Method method) {
            return AnnotationUtils.findAnnotation((Method)method, ExceptionHandler.class) != null;
        }
    };

    public ExceptionHandlerExceptionResolver() {
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.messageConverters = new ArrayList();
        this.messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new XmlAwareFormHttpMessageConverter());
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (argumentResolvers != null) {
            this.argumentResolvers = new HandlerMethodArgumentResolverComposite();
            this.argumentResolvers.addResolvers(argumentResolvers);
        }
    }

    public void setCustomReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        this.customReturnValueHandlers = returnValueHandlers;
    }

    public void setReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        if (returnValueHandlers != null) {
            this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
            this.returnValueHandlers.addHandlers(returnValueHandlers);
        }
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void afterPropertiesSet() {
        if (this.argumentResolvers == null) {
            this.argumentResolvers = new HandlerMethodArgumentResolverComposite();
            this.argumentResolvers.addResolvers(this.customArgumentResolvers);
            this.argumentResolvers.addResolvers(ExceptionHandlerExceptionResolver.getDefaultArgumentResolvers());
        }
        if (this.returnValueHandlers == null) {
            this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
            this.returnValueHandlers.addHandlers(this.customReturnValueHandlers);
            this.returnValueHandlers.addHandlers(ExceptionHandlerExceptionResolver.getDefaultReturnValueHandlers(this.messageConverters));
        }
    }

    public static List<HandlerMethodArgumentResolver> getDefaultArgumentResolvers() {
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        resolvers.add(new ServletRequestMethodArgumentResolver());
        resolvers.add(new ServletResponseMethodArgumentResolver());
        return resolvers;
    }

    public static List<HandlerMethodReturnValueHandler> getDefaultReturnValueHandlers(List<HttpMessageConverter<?>> messageConverters) {
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>();
        handlers.add(new RequestResponseBodyMethodProcessor(messageConverters));
        handlers.add((HandlerMethodReturnValueHandler)new ModelAttributeMethodProcessor(false));
        handlers.add(new ModelAndViewMethodReturnValueHandler());
        handlers.add((HandlerMethodReturnValueHandler)new ModelMethodProcessor());
        handlers.add(new ViewMethodReturnValueHandler());
        handlers.add(new HttpEntityMethodProcessor(messageConverters));
        handlers.add(new DefaultMethodReturnValueHandler());
        return handlers;
    }

    @Override
    protected ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception ex) {
        ExceptionMethodMapping mapping;
        Method method;
        if (handlerMethod != null && (method = (mapping = this.getExceptionMethodMapping(handlerMethod)).getMethod(ex)) != null) {
            Object handler = handlerMethod.getBean();
            ServletInvocableHandlerMethod exceptionHandler = new ServletInvocableHandlerMethod(handler, method);
            exceptionHandler.setHandlerMethodArgumentResolvers(this.argumentResolvers);
            exceptionHandler.setHandlerMethodReturnValueHandlers(this.returnValueHandlers);
            ServletWebRequest webRequest = new ServletWebRequest(request, response);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking exception-handling method: " + (Object)((Object)exceptionHandler)));
                }
                ModelAndViewContainer mavContainer = new ModelAndViewContainer();
                exceptionHandler.invokeAndHandle((NativeWebRequest)webRequest, mavContainer, ex);
                if (!mavContainer.isResolveView()) {
                    return new ModelAndView();
                }
                ModelAndView mav = new ModelAndView().addAllObjects((Map<String, ?>)mavContainer.getModel());
                mav.setViewName(mavContainer.getViewName());
                if (mavContainer.getView() != null) {
                    mav.setView((View)mavContainer.getView());
                }
                return mav;
            }
            catch (Exception invocationEx) {
                this.logger.error((Object)("Invoking exception-handling method resulted in exception : " + (Object)((Object)exceptionHandler)), (Throwable)invocationEx);
            }
        }
        return null;
    }

    private ExceptionMethodMapping getExceptionMethodMapping(HandlerMethod handlerMethod) {
        Class handlerType = handlerMethod.getBeanType();
        ExceptionMethodMapping mapping = this.exceptionMethodMappingCache.get(handlerType);
        if (mapping == null) {
            Set methods = HandlerMethodSelector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)EXCEPTION_HANDLER_METHODS);
            mapping = new ExceptionMethodMapping(methods);
            this.exceptionMethodMappingCache.put(handlerType, mapping);
        }
        return mapping;
    }
}

