/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.validation.Validator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceConfigurer;
import org.springframework.web.servlet.config.annotation.ViewControllerConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebMvcConfigurerComposite
implements WebMvcConfigurer {
    private final List<WebMvcConfigurer> delegates = new ArrayList<WebMvcConfigurer>();

    WebMvcConfigurerComposite() {
    }

    public void addWebMvcConfigurers(List<WebMvcConfigurer> configurers) {
        if (configurers != null) {
            this.delegates.addAll(configurers);
        }
    }

    @Override
    public void addFormatters(FormatterRegistry registry) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.addFormatters(registry);
        }
    }

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.configureMessageConverters(converters);
        }
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.addArgumentResolvers(argumentResolvers);
        }
    }

    @Override
    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.addReturnValueHandlers(returnValueHandlers);
        }
    }

    @Override
    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.configureHandlerExceptionResolvers(exceptionResolvers);
        }
    }

    @Override
    public void configureInterceptors(InterceptorConfigurer configurer) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.configureInterceptors(configurer);
        }
    }

    @Override
    public void configureViewControllers(ViewControllerConfigurer configurer) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.configureViewControllers(configurer);
        }
    }

    @Override
    public void configureResourceHandling(ResourceConfigurer configurer) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.configureResourceHandling(configurer);
        }
    }

    @Override
    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        for (WebMvcConfigurer delegate : this.delegates) {
            delegate.configureDefaultServletHandling(configurer);
        }
    }

    @Override
    public Validator getValidator() {
        HashMap<WebMvcConfigurer, Validator> validators = new HashMap<WebMvcConfigurer, Validator>();
        for (WebMvcConfigurer delegate : this.delegates) {
            Validator validator = delegate.getValidator();
            if (validator == null) continue;
            validators.put(delegate, validator);
        }
        if (validators.size() == 0) {
            return null;
        }
        if (validators.size() == 1) {
            return (Validator)validators.values().iterator().next();
        }
        throw new IllegalStateException("Multiple custom validators provided from [" + validators.keySet() + "]");
    }
}

