/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceConfigurer;
import org.springframework.web.servlet.config.annotation.ViewControllerConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerComposite;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
class WebMvcConfiguration
implements ApplicationContextAware,
ServletContextAware {
    private final WebMvcConfigurerComposite configurers = new WebMvcConfigurerComposite();
    private ServletContext servletContext;
    private ApplicationContext applicationContext;
    private List<MappedInterceptor> mappedInterceptors;
    private List<HttpMessageConverter<?>> messageConverters;
    private static final Validator NOOP_VALIDATOR = new Validator(){

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(Object target, Errors errors) {
        }
    };

    WebMvcConfiguration() {
    }

    @Autowired(required=false)
    public void setConfigurers(List<WebMvcConfigurer> configurers) {
        if (configurers == null || configurers.isEmpty()) {
            return;
        }
        this.configurers.addWebMvcConfigurers(configurers);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping mapping = new RequestMappingHandlerMapping();
        mapping.setInterceptors(this.getMappedInterceptors());
        mapping.setOrder(0);
        return mapping;
    }

    private Object[] getMappedInterceptors() {
        if (this.mappedInterceptors == null) {
            InterceptorConfigurer configurer = new InterceptorConfigurer();
            this.configurers.configureInterceptors(configurer);
            configurer.addInterceptor(new ConversionServiceExposingInterceptor((ConversionService)this.conversionService()));
            this.mappedInterceptors = configurer.getInterceptors();
        }
        return this.mappedInterceptors.toArray();
    }

    @Bean
    public HandlerMapping viewControllerHandlerMapping() {
        ViewControllerConfigurer configurer = new ViewControllerConfigurer();
        configurer.setOrder(1);
        this.configurers.configureViewControllers(configurer);
        SimpleUrlHandlerMapping handlerMapping = configurer.getHandlerMapping();
        handlerMapping.setInterceptors(this.getMappedInterceptors());
        return handlerMapping;
    }

    @Bean
    public BeanNameUrlHandlerMapping beanNameHandlerMapping() {
        BeanNameUrlHandlerMapping mapping = new BeanNameUrlHandlerMapping();
        mapping.setOrder(2);
        mapping.setInterceptors(this.getMappedInterceptors());
        return mapping;
    }

    @Bean
    public HandlerMapping resourceHandlerMapping() {
        ResourceConfigurer configurer = new ResourceConfigurer(this.applicationContext, this.servletContext);
        configurer.setOrder(0x7FFFFFFE);
        this.configurers.configureResourceHandling(configurer);
        return configurer.getHandlerMapping();
    }

    @Bean
    public HandlerMapping defaultServletHandlerMapping() {
        DefaultServletHandlerConfigurer configurer = new DefaultServletHandlerConfigurer(this.servletContext);
        this.configurers.configureDefaultServletHandling(configurer);
        return configurer.getHandlerMapping();
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter();
        adapter.setMessageConverters(this.getMessageConverters());
        ConfigurableWebBindingInitializer bindingInitializer = new ConfigurableWebBindingInitializer();
        bindingInitializer.setConversionService((ConversionService)this.conversionService());
        bindingInitializer.setValidator(this.validator());
        adapter.setWebBindingInitializer((WebBindingInitializer)bindingInitializer);
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
        this.configurers.addArgumentResolvers(argumentResolvers);
        adapter.setCustomArgumentResolvers(argumentResolvers);
        ArrayList<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
        this.configurers.addReturnValueHandlers(returnValueHandlers);
        adapter.setCustomReturnValueHandlers(returnValueHandlers);
        return adapter;
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.configurers.configureMessageConverters(this.messageConverters);
            if (this.messageConverters.isEmpty()) {
                this.addDefaultHttpMessageConverters(this.messageConverters);
            }
        }
        return this.messageConverters;
    }

    @Bean(name={"webMvcConversionService"})
    public FormattingConversionService conversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.configurers.addFormatters((FormatterRegistry)conversionService);
        return conversionService;
    }

    @Bean(name={"webMvcValidator"})
    public Validator validator() {
        Validator validator = this.configurers.getValidator();
        if (validator != null) {
            return validator;
        }
        if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
            Class clazz;
            try {
                String className = "org.springframework.validation.beanvalidation.LocalValidatorFactoryBean";
                clazz = ClassUtils.forName((String)className, (ClassLoader)WebMvcConfiguration.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BeanInitializationException("Could not find default validator");
            }
            catch (LinkageError linkageError) {
                throw new BeanInitializationException("Could not find default validator");
            }
            return (Validator)BeanUtils.instantiate((Class)clazz);
        }
        return NOOP_VALIDATOR;
    }

    private void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
        stringConverter.setWriteAcceptCharset(false);
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)stringConverter);
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new XmlAwareFormHttpMessageConverter());
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)classLoader)) {
            messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)classLoader)) {
            messageConverters.add((HttpMessageConverter<?>)new MappingJacksonHttpMessageConverter());
        }
        if (ClassUtils.isPresent((String)"com.sun.syndication.feed.WireFeed", (ClassLoader)classLoader)) {
            messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
    }

    @Bean
    public HttpRequestHandlerAdapter httpRequestHandlerAdapter() {
        return new HttpRequestHandlerAdapter();
    }

    @Bean
    public SimpleControllerHandlerAdapter simpleControllerHandlerAdapter() {
        return new SimpleControllerHandlerAdapter();
    }

    @Bean
    public HandlerExceptionResolver handlerExceptionResolver() throws Exception {
        ArrayList<HandlerExceptionResolver> resolvers = new ArrayList<HandlerExceptionResolver>();
        this.configurers.configureHandlerExceptionResolvers(resolvers);
        if (resolvers.size() == 0) {
            resolvers.add(this.createExceptionHandlerExceptionResolver());
            resolvers.add(new ResponseStatusExceptionResolver());
            resolvers.add(new DefaultHandlerExceptionResolver());
        }
        HandlerExceptionResolverComposite composite = new HandlerExceptionResolverComposite();
        composite.setOrder(0);
        composite.setExceptionResolvers(resolvers);
        return composite;
    }

    private HandlerExceptionResolver createExceptionHandlerExceptionResolver() throws Exception {
        ExceptionHandlerExceptionResolver resolver = new ExceptionHandlerExceptionResolver();
        resolver.setMessageConverters(this.getMessageConverters());
        resolver.afterPropertiesSet();
        return resolver;
    }
}

