/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.ParameterizableViewController;

public class ViewControllerConfigurer {
    private final Map<String, Controller> urlMap = new LinkedHashMap<String, Controller>();
    private int order = 1;

    public ViewControllerConfigurer mapViewNameByConvention(String urlPath) {
        return this.mapViewName(urlPath, null);
    }

    public ViewControllerConfigurer mapViewName(String urlPath, String viewName) {
        ParameterizableViewController controller = new ParameterizableViewController();
        controller.setViewName(viewName);
        this.urlMap.put(urlPath, controller);
        return this;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    protected SimpleUrlHandlerMapping getHandlerMapping() {
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(this.order);
        handlerMapping.setUrlMap(this.urlMap);
        return handlerMapping;
    }
}

