/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConfigurer {
    private final List<String> pathPatterns = new ArrayList<String>();
    private final List<Resource> locations = new ArrayList<Resource>();
    private Integer cachePeriod;
    private int order = 0x7FFFFFFE;
    private final ServletContext servletContext;
    private final ApplicationContext applicationContext;

    public ResourceConfigurer(ApplicationContext applicationContext, ServletContext servletContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext is required");
        this.applicationContext = applicationContext;
        this.servletContext = servletContext;
    }

    public ResourceConfigurer addPathMapping(String pathPattern) {
        return this.addPathMappings(pathPattern);
    }

    public ResourceConfigurer addPathMappings(String ... pathPatterns) {
        String[] stringArray = pathPatterns;
        int n = pathPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.pathPatterns.add(path);
            ++n2;
        }
        return this;
    }

    public ResourceConfigurer addResourceLocation(String resourceLocation) {
        return this.addResourceLocations(resourceLocation);
    }

    public ResourceConfigurer addResourceLocations(String ... resourceLocations) {
        String[] stringArray = resourceLocations;
        int n = resourceLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            this.locations.add(this.applicationContext.getResource(location));
            ++n2;
        }
        return this;
    }

    public ResourceConfigurer setCachePeriod(Integer cachePeriod) {
        this.cachePeriod = cachePeriod;
        return this;
    }

    public Integer getCachePeriod() {
        return this.cachePeriod;
    }

    public ResourceConfigurer setOrder(int order) {
        this.order = order;
        return this;
    }

    public Integer getOrder() {
        return this.order;
    }

    protected SimpleUrlHandlerMapping getHandlerMapping() {
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(this.order);
        handlerMapping.setUrlMap(this.getUrlMap());
        return handlerMapping;
    }

    private Map<String, HttpRequestHandler> getUrlMap() {
        LinkedHashMap<String, HttpRequestHandler> urlMap = new LinkedHashMap<String, HttpRequestHandler>();
        if (!this.pathPatterns.isEmpty()) {
            ResourceHttpRequestHandler requestHandler = this.createRequestHandler();
            for (String pathPattern : this.pathPatterns) {
                urlMap.put(pathPattern, requestHandler);
            }
        }
        return urlMap;
    }

    protected ResourceHttpRequestHandler createRequestHandler() {
        Assert.isTrue((!CollectionUtils.isEmpty(this.locations) ? 1 : 0) != 0, (String)"Path patterns specified but not resource locations.");
        ResourceHttpRequestHandler requestHandler = new ResourceHttpRequestHandler();
        requestHandler.setApplicationContext(this.applicationContext);
        requestHandler.setServletContext(this.servletContext);
        requestHandler.setLocations(this.locations);
        if (this.cachePeriod != null) {
            requestHandler.setCacheSeconds(this.cachePeriod);
        }
        return requestHandler;
    }
}

