/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorConfigurer {
    private final List<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>();

    public void addInterceptor(HandlerInterceptor interceptor) {
        this.register(null, interceptor);
    }

    public void addInterceptor(WebRequestInterceptor interceptor) {
        this.register(null, InterceptorConfigurer.asHandlerInterceptorArray(interceptor));
    }

    public void addInterceptors(HandlerInterceptor ... interceptors) {
        this.register(null, interceptors);
    }

    public void addInterceptors(WebRequestInterceptor ... interceptors) {
        this.register(null, InterceptorConfigurer.asHandlerInterceptorArray(interceptors));
    }

    public void mapInterceptor(String[] pathPatterns, HandlerInterceptor interceptor) {
        this.register(pathPatterns, interceptor);
    }

    public void mapInterceptor(String[] pathPatterns, WebRequestInterceptor interceptors) {
        this.register(pathPatterns, InterceptorConfigurer.asHandlerInterceptorArray(interceptors));
    }

    public void mapInterceptors(String[] pathPatterns, HandlerInterceptor ... interceptors) {
        this.register(pathPatterns, interceptors);
    }

    public void mapInterceptors(String[] pathPatterns, WebRequestInterceptor ... interceptors) {
        this.register(pathPatterns, InterceptorConfigurer.asHandlerInterceptorArray(interceptors));
    }

    private static HandlerInterceptor[] asHandlerInterceptorArray(WebRequestInterceptor ... interceptors) {
        HandlerInterceptor[] result = new HandlerInterceptor[interceptors.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new WebRequestHandlerInterceptorAdapter(interceptors[i]);
            ++i;
        }
        return result;
    }

    protected void register(String[] pathPatterns, HandlerInterceptor ... interceptors) {
        Assert.notEmpty((Object[])interceptors, (String)"At least one interceptor must be provided");
        HandlerInterceptor[] handlerInterceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerInterceptor interceptor = handlerInterceptorArray[n2];
            this.mappedInterceptors.add(new MappedInterceptor(pathPatterns, interceptor));
            ++n2;
        }
    }

    protected List<MappedInterceptor> getInterceptors() {
        return this.mappedInterceptors;
    }
}

