/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.DefaultServletHttpRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServletHandlerConfigurer {
    private DefaultServletHttpRequestHandler requestHandler;
    private final ServletContext servletContext;

    public DefaultServletHandlerConfigurer(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void enable() {
        this.enable(null);
    }

    public void enable(String defaultServletName) {
        this.requestHandler = new DefaultServletHttpRequestHandler();
        this.requestHandler.setDefaultServletName(defaultServletName);
        this.requestHandler.setServletContext(this.servletContext);
    }

    protected SimpleUrlHandlerMapping getHandlerMapping() {
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(Integer.MAX_VALUE);
        handlerMapping.setUrlMap(this.getUrlMap());
        return handlerMapping;
    }

    private Map<String, HttpRequestHandler> getUrlMap() {
        HashMap<String, HttpRequestHandler> urlMap = new HashMap<String, HttpRequestHandler>();
        if (this.requestHandler != null) {
            urlMap.put("/**", this.requestHandler);
        }
        return urlMap;
    }
}

