/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.config.AbstractSpecificationBeanDefinitionParser;
import org.springframework.context.config.FeatureSpecification;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.config.MvcAnnotationDriven;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationDrivenBeanDefinitionParser
extends AbstractSpecificationBeanDefinitionParser {
    AnnotationDrivenBeanDefinitionParser() {
    }

    protected FeatureSpecification doParse(Element element, ParserContext parserContext) {
        Element resolversElement;
        Element convertersElement;
        MvcAnnotationDriven spec = new MvcAnnotationDriven();
        if (element.hasAttribute("conversion-service")) {
            String conversionService = element.getAttribute("conversion-service");
            spec.conversionService(conversionService);
        }
        if (element.hasAttribute("validator")) {
            spec.validator(element.getAttribute("validator"));
        }
        if (element.hasAttribute("message-codes-resolver")) {
            spec.messageCodesResolver(element.getAttribute("message-codes-resolver"));
        }
        if ((convertersElement = DomUtils.getChildElementByTagName((Element)element, (String)"message-converters")) != null) {
            if (convertersElement.hasAttribute("register-defaults")) {
                spec.shouldRegisterDefaultMessageConverters(Boolean.valueOf(convertersElement.getAttribute("register-defaults")));
            }
            spec.messageConverters(this.extractBeanSubElements(convertersElement, parserContext));
        }
        if ((resolversElement = DomUtils.getChildElementByTagName((Element)element, (String)"argument-resolvers")) != null) {
            spec.argumentResolvers(this.extractBeanSubElements(resolversElement, parserContext));
        }
        return spec;
    }

    private ManagedList<? super Object> extractBeanSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.extractSource((Object)parentElement));
        for (Element beanElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String)"bean")) {
            BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDef);
            list.add((Object)beanDef);
        }
        return list;
    }
}

