/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.util.xml.SimpleTransformErrorListener;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.xslt.TransformerUtils;
import org.springframework.web.util.NestedServletException;
import org.w3c.dom.Node;

public abstract class AbstractXsltView
extends AbstractView {
    public static final String DEFAULT_ROOT = "DocRoot";
    private Resource stylesheetLocation;
    private String root = "DocRoot";
    private boolean useSingleModelNameAsRoot = true;
    private URIResolver uriResolver;
    private ErrorListener errorListener = new SimpleTransformErrorListener(this.logger);
    private boolean indent = true;
    private Properties outputProperties;
    private boolean cache = true;
    private TransformerFactory transformerFactory;
    private Templates templates;

    public void setStylesheetLocation(Resource stylesheetLocation) {
        this.stylesheetLocation = stylesheetLocation;
        if (this.transformerFactory != null) {
            this.cacheTemplates();
        }
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setUseSingleModelNameAsRoot(boolean useSingleModelNameAsRoot) {
        this.useSingleModelNameAsRoot = useSingleModelNameAsRoot;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        this.transformerFactory = TransformerFactory.newInstance();
        this.transformerFactory.setErrorListener(this.errorListener);
        if (this.uriResolver != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using custom URIResolver [" + this.uriResolver + "] in XSLT view with name '" + this.getBeanName() + "'"));
            }
            this.transformerFactory.setURIResolver(this.uriResolver);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("URL in view is " + this.stylesheetLocation));
        }
        this.cacheTemplates();
    }

    private synchronized void cacheTemplates() throws ApplicationContextException {
        if (this.stylesheetLocation != null) {
            try {
                this.templates = this.transformerFactory.newTemplates(this.getStylesheetSource(this.stylesheetLocation));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded templates [" + this.templates + "] in XSLT view '" + this.getBeanName() + "'"));
                }
            }
            catch (TransformerConfigurationException ex) {
                throw new ApplicationContextException("Can't load stylesheet from " + this.stylesheetLocation + " in XSLT view '" + this.getBeanName() + "'", (Throwable)ex);
            }
        }
    }

    protected Source getStylesheetSource(Resource stylesheetLocation) throws ApplicationContextException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading XSLT stylesheet from " + stylesheetLocation));
        }
        try {
            URL url = stylesheetLocation.getURL();
            String urlPath = url.toString();
            String systemId = urlPath.substring(0, urlPath.lastIndexOf(47) + 1);
            return new StreamSource(url.openStream(), systemId);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Can't load XSLT stylesheet from " + stylesheetLocation, (Throwable)ex);
        }
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.cache) {
            this.logger.warn((Object)"DEBUG SETTING: NOT THREADSAFE AND WILL IMPAIR PERFORMANCE: template will be refreshed");
            this.cacheTemplates();
        }
        if (this.templates == null) {
            if (this.transformerFactory == null) {
                throw new ServletException("XLST view is incorrectly configured. Templates AND TransformerFactory are null");
            }
            this.logger.warn((Object)"XSLT view is not configured: will copy XML input");
            response.setContentType("text/xml; charset=ISO-8859-1");
        } else {
            response.setContentType(this.getContentType());
        }
        Source source = null;
        String docRoot = null;
        Object singleModel = null;
        if (this.useSingleModelNameAsRoot && model.size() == 1) {
            docRoot = (String)model.keySet().iterator().next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Single model object received, key [" + docRoot + "] will be used as root tag"));
            }
            singleModel = model.get(docRoot);
        }
        if (singleModel instanceof Node || singleModel instanceof Source) {
            this.logger.debug((Object)"No need to domify: was passed an XML Node or Source");
            source = singleModel instanceof Node ? new DOMSource(singleModel) : (Source)singleModel;
        } else {
            source = this.createXsltSource(model, docRoot != null ? docRoot : this.root, request, response);
        }
        this.doTransform(model, source, request, response);
    }

    protected Source createXsltSource(Map model, String root, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    protected void doTransform(Map model, Source source, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doTransform(source, this.getParameters(request), new StreamResult(new BufferedOutputStream((OutputStream)response.getOutputStream())), response.getCharacterEncoding());
    }

    protected void doTransform(Source source, Map parameters, Result result, String encoding) throws Exception {
        try {
            Transformer trans;
            Transformer transformer = trans = this.templates != null ? this.templates.newTransformer() : this.transformerFactory.newTransformer();
            if (this.uriResolver != null) {
                trans.setURIResolver(this.uriResolver);
            }
            if (parameters != null) {
                Iterator it = parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    trans.setParameter(entry.getKey().toString(), entry.getValue());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Added parameters [" + parameters + "] to transformer object"));
                }
            }
            trans.setOutputProperty("encoding", encoding);
            if (this.indent) {
                TransformerUtils.enableIndenting(trans);
            }
            if (this.outputProperties != null) {
                Enumeration<?> propsEnum = this.outputProperties.propertyNames();
                while (propsEnum.hasMoreElements()) {
                    String propName = (String)propsEnum.nextElement();
                    trans.setOutputProperty(propName, this.outputProperties.getProperty(propName));
                }
            }
            trans.transform(source, result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("XSLT transformed with stylesheet [" + this.stylesheetLocation + "]"));
            }
        }
        catch (TransformerConfigurationException ex) {
            throw new NestedServletException("Couldn't create XSLT transformer for stylesheet [" + this.stylesheetLocation + "] in XSLT view with name [" + this.getBeanName() + "]", (Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new NestedServletException("Couldn't perform transform with stylesheet [" + this.stylesheetLocation + "] in XSLT view with name [" + this.getBeanName() + "]", (Throwable)ex);
        }
    }

    protected Map getParameters(HttpServletRequest request) {
        return this.getParameters();
    }

    protected Map getParameters() {
        return null;
    }
}

