/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.multipart;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.util.ActionRequestWrapper;

public class DefaultMultipartActionRequest
extends ActionRequestWrapper
implements MultipartActionRequest {
    private Map multipartFiles;
    private Map multipartParameters;

    public DefaultMultipartActionRequest(ActionRequest request, Map multipartFiles, Map multipartParameters) {
        super(request);
        this.setMultipartFiles(multipartFiles);
        this.setMultipartParameters(multipartParameters);
    }

    protected DefaultMultipartActionRequest(ActionRequest request) {
        super(request);
    }

    public Iterator getFileNames() {
        return this.getMultipartFiles().keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.getMultipartFiles().get(name);
    }

    public Map getFileMap() {
        return this.getMultipartFiles();
    }

    public Enumeration getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        Enumeration paramEnum = super.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add(paramEnum.nextElement());
        }
        paramNames.addAll(this.getMultipartParameters().keySet());
        return Collections.enumeration(paramNames);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.getMultipartParameters().get(name);
        if (values != null) {
            return values.length > 0 ? values[0] : null;
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.getMultipartParameters().get(name);
        if (values != null) {
            return values;
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap paramMap = new HashMap();
        paramMap.putAll(super.getParameterMap());
        paramMap.putAll(this.getMultipartParameters());
        return paramMap;
    }

    protected final void setMultipartFiles(Map multipartFiles) {
        this.multipartFiles = Collections.unmodifiableMap(multipartFiles);
    }

    protected Map getMultipartFiles() {
        if (this.multipartFiles == null) {
            this.initializeMultipart();
        }
        return this.multipartFiles;
    }

    protected final void setMultipartParameters(Map multipartParameters) {
        this.multipartParameters = multipartParameters;
    }

    protected Map getMultipartParameters() {
        if (this.multipartParameters == null) {
            this.initializeMultipart();
        }
        return this.multipartParameters;
    }

    protected void initializeMultipart() {
        throw new IllegalStateException("Multipart request not initialized");
    }
}

