/*
 * Copyright 2002-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.web.reactive.result.method.annotation;

import org.jspecify.annotations.Nullable;

import org.springframework.web.bind.support.WebExchangeDataBinder;

/**
 * Extended variant of {@link WebExchangeDataBinder} that adds URI path variables
 * and request headers to the bind values map.
 *
 * <p>Note: This class has existed since 5.0, but only as a private class within
 * {@link org.springframework.web.reactive.BindingContext}.
 *
 * @author Rossen Stoyanchev
 * @since 6.2.1
 * @deprecated in favor of the relocated
 * {@link org.springframework.web.reactive.result.ExtendedWebExchangeDataBinder}
 */
@Deprecated(since = "7.0.2", forRemoval = true)
public class ExtendedWebExchangeDataBinder extends org.springframework.web.reactive.result.ExtendedWebExchangeDataBinder {

	public ExtendedWebExchangeDataBinder(@Nullable Object target, String objectName) {
		super(target, objectName);
	}

}
