/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;
import org.springframework.web.reactive.accept.ApiVersionDeprecationHandler;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.server.ServerWebExchange;

public class DefaultApiVersionStrategy
implements ApiVersionStrategy {
    private final List<ApiVersionResolver> versionResolvers;
    private final ApiVersionParser<?> versionParser;
    private final boolean versionRequired;
    private final @Nullable Comparable<?> defaultVersion;
    private final Set<Comparable<?>> supportedVersions = new TreeSet();
    private final boolean detectSupportedVersions;
    private final Set<Comparable<?>> detectedVersions = new TreeSet();
    private final Predicate<Comparable<?>> supportedVersionPredicate;
    private final @Nullable ApiVersionDeprecationHandler deprecationHandler;

    public DefaultApiVersionStrategy(List<ApiVersionResolver> versionResolvers, ApiVersionParser<?> versionParser, @Nullable Boolean versionRequired, @Nullable String defaultVersion, boolean detectSupportedVersions, @Nullable Predicate<Comparable<?>> supportedVersionPredicate, @Nullable ApiVersionDeprecationHandler deprecationHandler) {
        Assert.notEmpty(versionResolvers, (String)"At least one ApiVersionResolver is required");
        Assert.notNull(versionParser, (String)"ApiVersionParser is required");
        Assert.isTrue((defaultVersion == null || versionRequired == null || versionRequired == false ? 1 : 0) != 0, (String)"versionRequired cannot be set to true if a defaultVersion is also configured");
        this.versionResolvers = new ArrayList<ApiVersionResolver>(versionResolvers);
        this.versionParser = versionParser;
        this.versionRequired = versionRequired != null ? versionRequired : defaultVersion == null;
        this.defaultVersion = defaultVersion != null ? versionParser.parseVersion(defaultVersion) : null;
        this.detectSupportedVersions = detectSupportedVersions;
        this.supportedVersionPredicate = this.initSupportedVersionPredicate(supportedVersionPredicate);
        this.deprecationHandler = deprecationHandler;
    }

    private Predicate<Comparable<?>> initSupportedVersionPredicate(@Nullable Predicate<Comparable<?>> predicate) {
        return predicate != null ? predicate : version -> this.supportedVersions.contains(version) || this.detectSupportedVersions && this.detectedVersions.contains(version);
    }

    @Override
    public @Nullable Comparable<?> getDefaultVersion() {
        return this.defaultVersion;
    }

    public boolean detectSupportedVersions() {
        return this.detectSupportedVersions;
    }

    public void addSupportedVersion(String ... versions) {
        for (String version : versions) {
            this.supportedVersions.add(this.parseVersion(version));
        }
    }

    public void addMappedVersion(String ... versions) {
        for (String version : versions) {
            this.detectedVersions.add(this.parseVersion(version));
        }
    }

    @Override
    public @Nullable String resolveVersion(ServerWebExchange exchange2) {
        for (ApiVersionResolver resolver : this.versionResolvers) {
            String version = resolver.resolveVersion(exchange2);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Override
    public Comparable<?> parseVersion(String version) {
        return this.versionParser.parseVersion(version);
    }

    @Override
    public void validateVersion(@Nullable Comparable<?> requestVersion, ServerWebExchange exchange2) throws MissingApiVersionException, InvalidApiVersionException {
        if (requestVersion == null) {
            if (this.versionRequired) {
                throw new MissingApiVersionException();
            }
            return;
        }
        if (!this.supportedVersionPredicate.test(requestVersion)) {
            throw new InvalidApiVersionException(requestVersion.toString());
        }
    }

    @Override
    public void handleDeprecations(Comparable<?> version, ServerWebExchange exchange2) {
        if (this.deprecationHandler != null) {
            this.deprecationHandler.handleVersion(version, exchange2);
        }
    }

    public String toString() {
        return "DefaultApiVersionStrategy[supportedVersions=" + String.valueOf(this.supportedVersions) + ", mappedVersions=" + String.valueOf(this.detectedVersions) + ", detectSupportedVersions=" + this.detectSupportedVersions + ", versionRequired=" + this.versionRequired + ", defaultVersion=" + String.valueOf(this.defaultVersion) + "]";
    }
}

