/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.ChangePathPatternParserVisitor;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.PathResourceLookupFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.ResourceHandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctionBuilder;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ToStringVisitor;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RouterFunctions {
    private static final Log logger = LogFactory.getLog(RouterFunctions.class);
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    public static final String MATCHING_PATTERN_ATTRIBUTE = RouterFunctions.class.getName() + ".matchingPattern";

    public static Builder route() {
        return new RouterFunctionBuilder();
    }

    public static <T extends ServerResponse> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        return new DefaultRouterFunction<T>(predicate, handlerFunction);
    }

    public static <T extends ServerResponse> RouterFunction<T> nest(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        return new DefaultNestedRouterFunction<T>(predicate, routerFunction);
    }

    public static RouterFunction<ServerResponse> resources(String pattern, Resource location) {
        return RouterFunctions.resources(RouterFunctions.resourceLookupFunction(pattern, location));
    }

    public static Function<ServerRequest, Mono<Resource>> resourceLookupFunction(String pattern, Resource location) {
        return new PathResourceLookupFunction(pattern, location);
    }

    public static RouterFunction<ServerResponse> resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        return new ResourcesRouterFunction(lookupFunction);
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHttpHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        WebHandler webHandler = RouterFunctions.toWebHandler(routerFunction, strategies);
        return WebHttpHandlerBuilder.webHandler((WebHandler)webHandler).filters(filters -> filters.addAll(strategies.webFilters())).exceptionHandlers(handlers -> handlers.addAll(strategies.exceptionHandlers())).localeContextResolver(strategies.localeContextResolver()).build();
    }

    public static WebHandler toWebHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toWebHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static WebHandler toWebHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return new RouterFunctionWebHandler(strategies, routerFunction);
    }

    public static <T extends ServerResponse> RouterFunction<T> changeParser(RouterFunction<T> routerFunction, PathPatternParser parser) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)parser, (String)"Parser must not be null");
        ChangePathPatternParserVisitor visitor = new ChangePathPatternParserVisitor(parser);
        routerFunction.accept(visitor);
        return routerFunction;
    }

    private static final class DefaultRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RequestPredicate predicate;
        private final HandlerFunction<T> handlerFunction;

        public DefaultRouterFunction(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
            Assert.notNull((Object)predicate, (String)"Predicate must not be null");
            Assert.notNull(handlerFunction, (String)"HandlerFunction must not be null");
            this.predicate = predicate;
            this.handlerFunction = handlerFunction;
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest request) {
            if (this.predicate.test(request)) {
                if (logger.isTraceEnabled()) {
                    String logPrefix = request.exchange().getLogPrefix();
                    logger.trace((Object)(logPrefix + String.format("Matched %s", this.predicate)));
                }
                return Mono.just(this.handlerFunction);
            }
            return Mono.empty();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.route(this.predicate, this.handlerFunction);
        }
    }

    private static final class DefaultNestedRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RequestPredicate predicate;
        private final RouterFunction<T> routerFunction;

        public DefaultNestedRouterFunction(RequestPredicate predicate, RouterFunction<T> routerFunction) {
            Assert.notNull((Object)predicate, (String)"Predicate must not be null");
            Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
            this.predicate = predicate;
            this.routerFunction = routerFunction;
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest serverRequest) {
            return this.predicate.nest(serverRequest).map(nestedRequest -> {
                if (logger.isTraceEnabled()) {
                    String logPrefix = serverRequest.exchange().getLogPrefix();
                    logger.trace((Object)(logPrefix + String.format("Matched nested %s", this.predicate)));
                }
                return this.routerFunction.route((ServerRequest)nestedRequest).doOnNext(match -> {
                    if (nestedRequest != serverRequest) {
                        serverRequest.attributes().clear();
                        serverRequest.attributes().putAll(nestedRequest.attributes());
                    }
                });
            }).orElseGet(Mono::empty);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startNested(this.predicate);
            this.routerFunction.accept(visitor);
            visitor.endNested(this.predicate);
        }
    }

    private static class ResourcesRouterFunction
    extends AbstractRouterFunction<ServerResponse> {
        private final Function<ServerRequest, Mono<Resource>> lookupFunction;

        public ResourcesRouterFunction(Function<ServerRequest, Mono<Resource>> lookupFunction) {
            Assert.notNull(lookupFunction, (String)"Function must not be null");
            this.lookupFunction = lookupFunction;
        }

        @Override
        public Mono<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return this.lookupFunction.apply(request).map(ResourceHandlerFunction::new);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.resources(this.lookupFunction);
        }
    }

    private static class RouterFunctionWebHandler
    implements WebHandler {
        private final HandlerStrategies strategies;
        private final RouterFunction<?> routerFunction;

        public RouterFunctionWebHandler(HandlerStrategies strategies, RouterFunction<?> routerFunction) {
            this.strategies = strategies;
            this.routerFunction = routerFunction;
        }

        public Mono<Void> handle(ServerWebExchange exchange2) {
            return Mono.defer(() -> {
                DefaultServerRequest request = new DefaultServerRequest(exchange2, this.strategies.messageReaders());
                this.addAttributes(exchange2, request);
                return this.routerFunction.route(request).switchIfEmpty(this.createNotFoundError()).flatMap(handlerFunction -> RouterFunctionWebHandler.wrapException(() -> handlerFunction.handle(request))).flatMap(response -> RouterFunctionWebHandler.wrapException(() -> response.writeTo(exchange2, new HandlerStrategiesResponseContext(this.strategies))));
            });
        }

        private void addAttributes(ServerWebExchange exchange2, ServerRequest request) {
            Map attributes = exchange2.getAttributes();
            attributes.put(REQUEST_ATTRIBUTE, request);
        }

        private <R> Mono<R> createNotFoundError() {
            return Mono.defer(() -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND)));
        }

        private static <T> Mono<T> wrapException(Supplier<Mono<T>> supplier) {
            try {
                return supplier.get();
            }
            catch (Throwable ex) {
                return Mono.error((Throwable)ex);
            }
        }
    }

    public static interface Visitor {
        public void startNested(RequestPredicate var1);

        public void endNested(RequestPredicate var1);

        public void route(RequestPredicate var1, HandlerFunction<?> var2);

        public void resources(Function<ServerRequest, Mono<Resource>> var1);

        public void attributes(Map<String, Object> var1);

        public void unknown(RouterFunction<?> var1);
    }

    private static class HandlerStrategiesResponseContext
    implements ServerResponse.Context {
        private final HandlerStrategies strategies;

        public HandlerStrategiesResponseContext(HandlerStrategies strategies) {
            this.strategies = strategies;
        }

        @Override
        public List<HttpMessageWriter<?>> messageWriters() {
            return this.strategies.messageWriters();
        }

        @Override
        public List<ViewResolver> viewResolvers() {
            return this.strategies.viewResolvers();
        }
    }

    static final class AttributesRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RouterFunction<T> delegate;
        private final Map<String, Object> attributes;

        public AttributesRouterFunction(RouterFunction<T> delegate, Map<String, Object> attributes) {
            this.delegate = delegate;
            this.attributes = AttributesRouterFunction.initAttributes(attributes);
        }

        private static Map<String, Object> initAttributes(Map<String, Object> attributes) {
            if (attributes.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest request) {
            return this.delegate.route(request);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.attributes(this.attributes);
            this.delegate.accept(visitor);
        }

        @Override
        public RouterFunction<T> withAttribute(String name, Object value) {
            Assert.hasLength((String)name, (String)"Name must not be empty");
            Assert.notNull((Object)value, (String)"Value must not be null");
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(this.attributes);
            attributes.put(name, value);
            return new AttributesRouterFunction<T>(this.delegate, attributes);
        }

        @Override
        public RouterFunction<T> withAttributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"AttributesConsumer must not be null");
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(this.attributes);
            attributesConsumer.accept(attributes);
            return new AttributesRouterFunction<T>(this.delegate, attributes);
        }
    }

    static final class FilteredRouterFunction<T extends ServerResponse, S extends ServerResponse>
    implements RouterFunction<S> {
        private final RouterFunction<T> routerFunction;
        private final HandlerFilterFunction<T, S> filterFunction;

        public FilteredRouterFunction(RouterFunction<T> routerFunction, HandlerFilterFunction<T, S> filterFunction) {
            this.routerFunction = routerFunction;
            this.filterFunction = filterFunction;
        }

        @Override
        public Mono<HandlerFunction<S>> route(ServerRequest request) {
            return this.routerFunction.route(request).map(this.filterFunction::apply);
        }

        @Override
        public void accept(Visitor visitor) {
            this.routerFunction.accept(visitor);
        }

        public String toString() {
            return this.routerFunction.toString();
        }
    }

    static final class DifferentComposedRouterFunction
    extends AbstractRouterFunction<ServerResponse> {
        private final RouterFunction<?> first;
        private final RouterFunction<?> second;

        public DifferentComposedRouterFunction(RouterFunction<?> first, RouterFunction<?> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Mono<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return Flux.concat((Publisher[])new Publisher[]{this.first.route(request), Mono.defer(() -> this.second.route(request))}).next().map(this::cast);
        }

        private <T extends ServerResponse> HandlerFunction<T> cast(HandlerFunction<?> handlerFunction) {
            return handlerFunction;
        }

        @Override
        public void accept(Visitor visitor) {
            this.first.accept(visitor);
            this.second.accept(visitor);
        }
    }

    static final class SameComposedRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RouterFunction<T> first;
        private final RouterFunction<T> second;

        public SameComposedRouterFunction(RouterFunction<T> first, RouterFunction<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest request) {
            return Flux.concat((Publisher[])new Publisher[]{this.first.route(request), Mono.defer(() -> this.second.route(request))}).next();
        }

        @Override
        public void accept(Visitor visitor) {
            this.first.accept(visitor);
            this.second.accept(visitor);
        }
    }

    static abstract class AbstractRouterFunction<T extends ServerResponse>
    implements RouterFunction<T> {
        AbstractRouterFunction() {
        }

        public String toString() {
            ToStringVisitor visitor = new ToStringVisitor();
            this.accept(visitor);
            return visitor.toString();
        }
    }

    public static interface Builder {
        public Builder GET(HandlerFunction<ServerResponse> var1);

        public Builder GET(String var1, HandlerFunction<ServerResponse> var2);

        public Builder GET(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder GET(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder HEAD(HandlerFunction<ServerResponse> var1);

        public Builder HEAD(String var1, HandlerFunction<ServerResponse> var2);

        public Builder HEAD(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder HEAD(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder POST(HandlerFunction<ServerResponse> var1);

        public Builder POST(String var1, HandlerFunction<ServerResponse> var2);

        public Builder POST(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder POST(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder PUT(HandlerFunction<ServerResponse> var1);

        public Builder PUT(String var1, HandlerFunction<ServerResponse> var2);

        public Builder PUT(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder PUT(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder PATCH(HandlerFunction<ServerResponse> var1);

        public Builder PATCH(String var1, HandlerFunction<ServerResponse> var2);

        public Builder PATCH(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder PATCH(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder DELETE(HandlerFunction<ServerResponse> var1);

        public Builder DELETE(String var1, HandlerFunction<ServerResponse> var2);

        public Builder DELETE(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder DELETE(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder OPTIONS(HandlerFunction<ServerResponse> var1);

        public Builder OPTIONS(String var1, HandlerFunction<ServerResponse> var2);

        public Builder OPTIONS(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder OPTIONS(String var1, RequestPredicate var2, HandlerFunction<ServerResponse> var3);

        public Builder route(RequestPredicate var1, HandlerFunction<ServerResponse> var2);

        public Builder add(RouterFunction<ServerResponse> var1);

        public Builder resources(String var1, Resource var2);

        public Builder resources(Function<ServerRequest, Mono<Resource>> var1);

        public Builder nest(RequestPredicate var1, Supplier<RouterFunction<ServerResponse>> var2);

        public Builder nest(RequestPredicate var1, Consumer<Builder> var2);

        public Builder path(String var1, Supplier<RouterFunction<ServerResponse>> var2);

        public Builder path(String var1, Consumer<Builder> var2);

        public Builder filter(HandlerFilterFunction<ServerResponse, ServerResponse> var1);

        public Builder before(Function<ServerRequest, ServerRequest> var1);

        public Builder after(BiFunction<ServerRequest, ServerResponse, ServerResponse> var1);

        public Builder onError(Predicate<? super Throwable> var1, BiFunction<? super Throwable, ServerRequest, Mono<ServerResponse>> var2);

        public <T extends Throwable> Builder onError(Class<T> var1, BiFunction<? super T, ServerRequest, Mono<ServerResponse>> var2);

        public Builder withAttribute(String var1, Object var2);

        public Builder withAttributes(Consumer<Map<String, Object>> var1);

        public RouterFunction<ServerResponse> build();
    }
}

