/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client.support;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.service.invoker.AbstractReactorHttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebClientAdapter
extends AbstractReactorHttpExchangeAdapter {
    private final WebClient webClient;

    private WebClientAdapter(WebClient webClient) {
        this.webClient = webClient;
    }

    public boolean supportsRequestAttributes() {
        return true;
    }

    public Mono<Void> exchangeForMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().then();
    }

    public Mono<HttpHeaders> exchangeForHeadersMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().map(HttpEntity::getHeaders);
    }

    public <T> Mono<T> exchangeForBodyMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToMono(bodyType);
    }

    public <T> Flux<T> exchangeForBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToFlux(bodyType);
    }

    public Mono<ResponseEntity<Void>> exchangeForBodilessEntityMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity();
    }

    public <T> Mono<ResponseEntity<T>> exchangeForEntityMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntity(bodyType);
    }

    public <T> Mono<ResponseEntity<Flux<T>>> exchangeForEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntityFlux(bodyType);
    }

    private WebClient.RequestBodySpec newRequest(HttpRequestValues requestValues) {
        ReactiveHttpRequestValues reactiveRequestValues;
        Publisher body2;
        WebClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = requestValues.getHttpMethod();
        Assert.notNull((Object)httpMethod, (String)"HttpMethod is required");
        WebClient.RequestBodyUriSpec uriSpec = this.webClient.method(httpMethod);
        if (requestValues.getUri() != null) {
            bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(requestValues.getUri());
        } else if (requestValues.getUriTemplate() != null) {
            bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(requestValues.getUriTemplate(), requestValues.getUriVariables());
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        bodySpec.headers(headers -> headers.putAll((Map)requestValues.getHeaders()));
        bodySpec.cookies(cookies -> cookies.putAll((Map)requestValues.getCookies()));
        bodySpec.attributes(attributes -> attributes.putAll(requestValues.getAttributes()));
        if (requestValues.getBodyValue() != null) {
            bodySpec.bodyValue(requestValues.getBodyValue());
        } else if (requestValues instanceof ReactiveHttpRequestValues && (body2 = (reactiveRequestValues = (ReactiveHttpRequestValues)requestValues).getBodyPublisher()) != null) {
            ParameterizedTypeReference elementType = reactiveRequestValues.getBodyPublisherElementType();
            Assert.notNull((Object)elementType, (String)"Publisher body element type is required");
            bodySpec.body((Object)body2, elementType);
        }
        return bodySpec;
    }

    public static WebClientAdapter create(WebClient webClient) {
        return new WebClientAdapter(webClient);
    }

    @Deprecated(since="6.1", forRemoval=true)
    public static WebClientAdapter forClient(WebClient webClient) {
        return new WebClientAdapter(webClient);
    }
}

