/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.net.URI;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyWebSocketClient
implements WebSocketClient {
    private static final Log logger = LogFactory.getLog(ReactorNettyWebSocketClient.class);
    private final HttpClient httpClient;

    public ReactorNettyWebSocketClient() {
        this(HttpClient.create());
    }

    public ReactorNettyWebSocketClient(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders requestHeaders, WebSocketHandler handler) {
        return ((HttpClient.WebsocketSender)this.getHttpClient().headers(nettyHeaders -> this.setNettyHeaders(requestHeaders, (io.netty.handler.codec.http.HttpHeaders)nettyHeaders)).websocket(StringUtils.collectionToCommaDelimitedString(handler.getSubProtocols())).uri(url.toString())).handle((inbound, outbound) -> {
            HttpHeaders responseHeaders = this.toHttpHeaders((WebsocketInbound)inbound);
            String protocol = responseHeaders.getFirst("Sec-WebSocket-Protocol");
            HandshakeInfo info = new HandshakeInfo(url, responseHeaders, (Mono<Principal>)Mono.empty(), protocol);
            NettyDataBufferFactory factory = new NettyDataBufferFactory(outbound.alloc());
            ReactorNettyWebSocketSession session = new ReactorNettyWebSocketSession((WebsocketInbound)inbound, (WebsocketOutbound)outbound, info, factory);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started session '" + session.getId() + "' for " + url));
            }
            return handler.handle(session);
        }).doOnRequest(n -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connecting to " + url));
            }
        }).next();
    }

    private void setNettyHeaders(HttpHeaders httpHeaders, io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        httpHeaders.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)nettyHeaders).set(arg_0, arg_1));
    }

    private HttpHeaders toHttpHeaders(WebsocketInbound inbound) {
        HttpHeaders headers2 = new HttpHeaders();
        io.netty.handler.codec.http.HttpHeaders nettyHeaders = inbound.headers();
        nettyHeaders.forEach(entry -> {
            String name = (String)entry.getKey();
            headers2.put(name, nettyHeaders.getAll(name));
        });
        return headers2;
    }
}

