/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.server.WebSession;

class SessionAttributesHandler {
    private final Set<String> attributeNames = new HashSet<String>();
    private final Set<Class<?>> attributeTypes = new HashSet();
    private final Set<String> knownAttributeNames = Collections.newSetFromMap(new ConcurrentHashMap(4));

    public SessionAttributesHandler(Class<?> handlerType) {
        SessionAttributes ann = (SessionAttributes)AnnotatedElementUtils.findMergedAnnotation(handlerType, SessionAttributes.class);
        if (ann != null) {
            Collections.addAll(this.attributeNames, ann.names());
            Collections.addAll(this.attributeTypes, ann.types());
        }
        this.knownAttributeNames.addAll(this.attributeNames);
    }

    public boolean hasSessionAttributes() {
        return !this.attributeNames.isEmpty() || !this.attributeTypes.isEmpty();
    }

    public boolean isHandlerSessionAttribute(String attributeName, Class<?> attributeType) {
        Assert.notNull((Object)attributeName, (String)"Attribute name must not be null");
        if (this.attributeNames.contains(attributeName) || this.attributeTypes.contains(attributeType)) {
            this.knownAttributeNames.add(attributeName);
            return true;
        }
        return false;
    }

    public Map<String, Object> retrieveAttributes(WebSession session) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.knownAttributeNames.forEach(name -> {
            Object value = session.getAttribute(name);
            if (value != null) {
                attributes.put((String)name, value);
            }
        });
        return attributes;
    }

    public void storeAttributes(WebSession session, Map<String, ?> attributes) {
        attributes.keySet().forEach(name -> {
            Object value = attributes.get(name);
            if (value != null && this.isHandlerSessionAttribute((String)name, value.getClass())) {
                session.getAttributes().put(name, value);
            }
        });
    }

    public void cleanupAttributes(WebSession session) {
        this.knownAttributeNames.forEach(name -> session.getAttributes().remove(name));
    }
}

