/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.net.URI;
import java.util.List;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClientSupport;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class JettyWebSocketClient
extends WebSocketClientSupport
implements WebSocketClient,
Lifecycle {
    private final org.eclipse.jetty.websocket.client.WebSocketClient jettyClient;
    private final boolean externallyManaged;
    private boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public JettyWebSocketClient() {
        this.jettyClient = new org.eclipse.jetty.websocket.client.WebSocketClient();
        this.externallyManaged = false;
    }

    public JettyWebSocketClient(org.eclipse.jetty.websocket.client.WebSocketClient jettyClient) {
        this.jettyClient = jettyClient;
        this.externallyManaged = true;
    }

    public org.eclipse.jetty.websocket.client.WebSocketClient getJettyClient() {
        return this.jettyClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.externallyManaged) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                try {
                    this.running = true;
                    this.jettyClient.start();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to start Jetty WebSocketClient", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.externallyManaged) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.running = false;
                    this.jettyClient.stop();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Error stopping Jetty WebSocketClient", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        return this.executeInternal(url, headers2, handler);
    }

    private Mono<Void> executeInternal(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        MonoProcessor completionMono = MonoProcessor.create();
        return Mono.fromCallable(() -> {
            List<String> protocols = this.beforeHandshake(url, headers2, handler);
            ClientUpgradeRequest upgradeRequest = new ClientUpgradeRequest();
            upgradeRequest.setSubProtocols(protocols);
            Object jettyHandler = this.createJettyHandler(url, handler, (MonoProcessor<Void>)completionMono);
            DefaultUpgradeListener upgradeListener = new DefaultUpgradeListener(headers2);
            return this.jettyClient.connect(jettyHandler, url, upgradeRequest, (UpgradeListener)upgradeListener);
        }).then((Mono)completionMono);
    }

    private Object createJettyHandler(URI url, WebSocketHandler handler, MonoProcessor<Void> completion) {
        return new JettyWebSocketHandlerAdapter(handler, session -> {
            UpgradeResponse response = session.getUpgradeResponse();
            HttpHeaders responseHeaders = new HttpHeaders();
            response.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)responseHeaders).put(arg_0, arg_1));
            HandshakeInfo info = this.afterHandshake(url, responseHeaders);
            return new JettyWebSocketSession((Session)session, info, this.bufferFactory, completion);
        });
    }

    private static class DefaultUpgradeListener
    implements UpgradeListener {
        private final HttpHeaders headers;

        public DefaultUpgradeListener(HttpHeaders headers2) {
            this.headers = headers2;
        }

        public void onHandshakeRequest(UpgradeRequest request) {
            this.headers.forEach((arg_0, arg_1) -> ((UpgradeRequest)request).setHeader(arg_0, arg_1));
        }

        public void onHandshakeResponse(UpgradeResponse response) {
        }
    }
}

