/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageReaderArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestPartMethodArgumentResolver
extends AbstractMessageReaderArgumentResolver {
    public RequestPartMethodArgumentResolver(List<HttpMessageReader<?>> readers, ReactiveAdapterRegistry registry) {
        super(readers, registry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestPart.class)) return true;
        if (!this.checkParameterType(parameter, Part.class::isAssignableFrom)) return false;
        return true;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        ReactiveAdapter adapter;
        MethodParameter elementType;
        RequestPart requestPart = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean isRequired = requestPart == null || requestPart.required();
        String name = this.getPartName(parameter, requestPart);
        Flux partFlux = this.getPartValues(name, exchange);
        if (isRequired) {
            partFlux = partFlux.switchIfEmpty((Publisher)Flux.error((Throwable)this.getMissingPartException(name, parameter)));
        }
        MethodParameter methodParameter = elementType = (adapter = this.getAdapterRegistry().getAdapter(parameter.getParameterType())) != null ? parameter.nested() : parameter;
        if (Part.class.isAssignableFrom(elementType.getNestedParameterType())) {
            if (adapter != null) {
                partFlux = adapter.isMultiValue() ? partFlux : partFlux.take(1L);
                return Mono.just((Object)adapter.fromPublisher((Publisher)partFlux));
            }
            return partFlux.next().cast(Object.class);
        }
        return partFlux.next().flatMap(part -> {
            PartServerHttpRequest partRequest = new PartServerHttpRequest(exchange.getRequest(), (Part)part);
            ServerWebExchange partExchange = exchange.mutate().request((ServerHttpRequest)partRequest).build();
            return this.readBody(parameter, isRequired, bindingContext, partExchange);
        });
    }

    private String getPartName(MethodParameter methodParam, @Nullable RequestPart requestPart) {
        String partName;
        String string = partName = requestPart != null ? requestPart.name() : "";
        if (partName.isEmpty() && (partName = methodParam.getParameterName()) == null) {
            throw new IllegalArgumentException("Request part name for argument type [" + methodParam.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
        }
        return partName;
    }

    private Flux<Part> getPartValues(String name, ServerWebExchange exchange) {
        return exchange.getMultipartData().filter(map -> !CollectionUtils.isEmpty((Collection)((Collection)map.get((Object)name)))).flatMapIterable(map -> (List)map.getOrDefault((Object)name, Collections.emptyList()));
    }

    private ServerWebInputException getMissingPartException(String name, MethodParameter param) {
        String reason = "Required request part '" + name + "' is not present";
        return new ServerWebInputException(reason, param);
    }

    private static class PartServerHttpRequest
    extends ServerHttpRequestDecorator {
        private final Part part;

        public PartServerHttpRequest(ServerHttpRequest delegate, Part part) {
            super(delegate);
            this.part = part;
        }

        public HttpHeaders getHeaders() {
            return this.part.headers();
        }

        public Flux<DataBuffer> getBody() {
            return this.part.content();
        }
    }
}

