/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractionException;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;

public class RequestPathFlowExecutorArgumentHandler
extends RequestParameterFlowExecutorArgumentHandler {
    private static final char PATH_SEPARATOR_CHARACTER = '/';
    private static final String KEY_DELIMITER = "k";
    private String keyDelimiter = "k";

    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    public void setKeyDelimiter(String keyDelimiter) {
        this.keyDelimiter = keyDelimiter;
    }

    public boolean isFlowIdPresent(ExternalContext context) {
        String requestPathInfo = this.getRequestPathInfo(context);
        boolean hasFileName = StringUtils.hasText((String)WebUtils.extractFilenameFromUrlPath((String)requestPathInfo));
        return hasFileName || super.isFlowIdPresent(context);
    }

    public String extractFlowId(ExternalContext context) {
        String requestPathInfo = this.getRequestPathInfo(context);
        String extractedFilename = WebUtils.extractFilenameFromUrlPath((String)requestPathInfo);
        return StringUtils.hasText((String)extractedFilename) ? extractedFilename : super.extractFlowId(context);
    }

    public boolean isFlowExecutionKeyPresent(ExternalContext context) {
        String requestPathInfo = this.getRequestPathInfo(context);
        return requestPathInfo.startsWith(this.keyPath()) || super.isFlowExecutionKeyPresent(context);
    }

    public String extractFlowExecutionKey(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String requestPathInfo = this.getRequestPathInfo(context);
        int index = requestPathInfo.indexOf(this.keyPath());
        if (index != -1) {
            return requestPathInfo.substring(index + this.keyPath().length());
        }
        return super.extractFlowExecutionKey(context);
    }

    public String createFlowDefinitionUrl(FlowDefinitionRedirect flowDefinitionRedirect, ExternalContext context) {
        StringBuffer flowUrl = new StringBuffer();
        this.appendFlowExecutorPath(flowUrl, context);
        flowUrl.append('/');
        flowUrl.append(flowDefinitionRedirect.getFlowDefinitionId());
        if (!flowDefinitionRedirect.getExecutionInput().isEmpty()) {
            flowUrl.append('?');
            this.appendQueryParameters(flowUrl, flowDefinitionRedirect.getExecutionInput());
        }
        return flowUrl.toString();
    }

    public String createFlowExecutionUrl(String flowExecutionKey, FlowExecutionContext flowExecution, ExternalContext context) {
        StringBuffer flowExecutionUrl = new StringBuffer();
        this.appendFlowExecutorPath(flowExecutionUrl, context);
        flowExecutionUrl.append('/');
        flowExecutionUrl.append(this.keyDelimiter);
        flowExecutionUrl.append('/');
        flowExecutionUrl.append(flowExecutionKey);
        return flowExecutionUrl.toString();
    }

    protected void appendFlowExecutorPath(StringBuffer url, ExternalContext context) {
        url.append(context.getContextPath());
        url.append(context.getDispatcherPath());
    }

    private String getRequestPathInfo(ExternalContext context) {
        String requestPathInfo = context.getRequestPathInfo();
        return requestPathInfo != null ? requestPathInfo : "";
    }

    private String keyPath() {
        return '/' + this.keyDelimiter + '/';
    }
}

