/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.PermissionDeniedFlowExecutionAccessException;
import org.springframework.webflow.execution.repository.support.AbstractConversationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;
import org.springframework.webflow.execution.repository.support.InvalidContinuationIdException;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class SimpleFlowExecutionRepository
extends AbstractConversationFlowExecutionRepository {
    private static final String FLOW_EXECUTION_ENTRY_ATTRIBUTE = "flowExecutionEntry";
    private boolean alwaysGenerateNewNextKey = true;
    private UidGenerator continuationIdGenerator = new RandomGuidUidGenerator();

    public SimpleFlowExecutionRepository(FlowExecutionStateRestorer executionStateRestorer, ConversationManager conversationManager) {
        super(executionStateRestorer, conversationManager);
    }

    public boolean isAlwaysGenerateNewNextKey() {
        return this.alwaysGenerateNewNextKey;
    }

    public void setAlwaysGenerateNewNextKey(boolean alwaysGenerateNewNextKey) {
        this.alwaysGenerateNewNextKey = alwaysGenerateNewNextKey;
    }

    public UidGenerator getContinuationIdGenerator() {
        return this.continuationIdGenerator;
    }

    public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
        Assert.notNull((Object)continuationIdGenerator, (String)"The continuation id generator is required");
        this.continuationIdGenerator = continuationIdGenerator;
    }

    public FlowExecutionKey getNextKey(FlowExecution flowExecution, FlowExecutionKey previousKey) {
        if (this.isAlwaysGenerateNewNextKey()) {
            return super.getNextKey(flowExecution, previousKey);
        }
        return previousKey;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting flow execution with key '" + key + "'"));
        }
        try {
            FlowExecution execution = this.getEntry(key).access(this.getContinuationId(key));
            return this.getExecutionStateRestorer().restoreState(execution, this.getConversationScope(key));
        }
        catch (InvalidContinuationIdException e) {
            throw new PermissionDeniedFlowExecutionAccessException(key, (Exception)((Object)e));
        }
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting flow execution '" + flowExecution + "' into repository with key '" + key + "'"));
        }
        FlowExecutionEntry entry = new FlowExecutionEntry(this.getContinuationId(key), flowExecution);
        this.putEntry(key, entry);
        this.putConversationScope(key, flowExecution.getConversationScope());
    }

    protected Serializable generateContinuationId(FlowExecution flowExecution) {
        return this.continuationIdGenerator.generateUid();
    }

    protected Serializable parseContinuationId(String encodedId) {
        return this.continuationIdGenerator.parseUid(encodedId);
    }

    private FlowExecutionEntry getEntry(FlowExecutionKey key) {
        FlowExecutionEntry entry = (FlowExecutionEntry)this.getConversation(key).getAttribute(FLOW_EXECUTION_ENTRY_ATTRIBUTE);
        if (entry == null) {
            throw new IllegalStateException("No 'flowExecutionEntry' attribute present in the governing conversation: possible programmer error -- do not call get before calling put");
        }
        return entry;
    }

    private void putEntry(FlowExecutionKey key, FlowExecutionEntry entry) {
        this.getConversation(key).putAttribute(FLOW_EXECUTION_ENTRY_ATTRIBUTE, entry);
    }

    private static class FlowExecutionEntry
    implements Serializable {
        private Serializable continuationId;
        private FlowExecution flowExecution;

        public FlowExecutionEntry(Serializable continuationId, FlowExecution flowExecution) {
            this.continuationId = continuationId;
            this.flowExecution = flowExecution;
        }

        public FlowExecution access(Serializable continuationId) throws InvalidContinuationIdException {
            if (!this.continuationId.equals(continuationId)) {
                throw new InvalidContinuationIdException(continuationId);
            }
            return this.flowExecution;
        }
    }
}

