/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.continuation.ContinuationCreationException;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;

public class SerializedFlowExecutionContinuation
extends FlowExecutionContinuation
implements Externalizable {
    private byte[] flowExecutionData;
    private boolean compressed;

    public SerializedFlowExecutionContinuation() {
    }

    public SerializedFlowExecutionContinuation(FlowExecution flowExecution, boolean compress) throws ContinuationCreationException {
        try {
            this.flowExecutionData = this.serialize(flowExecution);
            if (compress) {
                this.flowExecutionData = this.compress(this.flowExecutionData);
            }
        }
        catch (NotSerializableException e) {
            throw new ContinuationCreationException(flowExecution, "Could not serialize flow execution; make sure all objects stored in flow or flash scope are serializable", e);
        }
        catch (IOException e) {
            throw new ContinuationCreationException(flowExecution, "IOException thrown serializing flow execution -- this should not happen!", e);
        }
        this.compressed = compress;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public FlowExecution unmarshal() throws ContinuationUnmarshalException {
        try {
            return this.deserialize(this.getFlowExecutionData());
        }
        catch (IOException e) {
            throw new ContinuationUnmarshalException("IOException thrown deserializing the flow execution stored in this continuation -- this should not happen!", e);
        }
        catch (ClassNotFoundException e) {
            throw new ContinuationUnmarshalException("ClassNotFoundException thrown deserializing the flow execution stored in this continuation -- This should not happen! Make sure there are no classloader issues. For example, perhaps the Web Flow system is being loaded by a classloader that is a parent of the classloader loading application classes?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.flowExecutionData.length + 40);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this);
                oos.flush();
            }
            finally {
                oos.close();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.flowExecutionData.length);
        out.write(this.flowExecutionData);
        out.writeBoolean(this.compressed);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.flowExecutionData = new byte[length];
        in.readFully(this.flowExecutionData);
        this.compressed = in.readBoolean();
    }

    protected byte[] getFlowExecutionData() throws IOException {
        if (this.isCompressed()) {
            return this.decompress(this.flowExecutionData);
        }
        return this.flowExecutionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(FlowExecution flowExecution) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(flowExecution);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlowExecution deserialize(byte[] data) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            FlowExecution flowExecution = (FlowExecution)ois.readObject();
            return flowExecution;
        }
        finally {
            ois.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] compress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipos = new GZIPOutputStream(baos);
        try {
            gzipos.write(dataToCompress);
            gzipos.flush();
        }
        finally {
            gzipos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] dataToDecompress) throws IOException {
        GZIPInputStream gzipin = new GZIPInputStream(new ByteArrayInputStream(dataToDecompress));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileCopyUtils.copy((InputStream)gzipin, (OutputStream)baos);
        }
        finally {
            gzipin.close();
        }
        return baos.toByteArray();
    }
}

