/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.context.MessageSource;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.method.MethodValidator;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.ModelAndViewContainer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private static final boolean KOTLIN_REFLECT_PRESENT = KotlinDetector.isKotlinReflectPresent();
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = DefaultParameterNameDiscoverer.getSharedInstance();
    private @Nullable WebDataBinderFactory dataBinderFactory;
    private @Nullable MethodValidator methodValidator;

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
    }

    protected InvocableHandlerMethod(Object bean, Method method, @Nullable MessageSource messageSource) {
        super(bean, method, messageSource);
    }

    public InvocableHandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean, methodName, parameterTypes);
    }

    public void setHandlerMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.resolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setDataBinderFactory(WebDataBinderFactory dataBinderFactory) {
        this.dataBinderFactory = dataBinderFactory;
    }

    public void setMethodValidator(@Nullable MethodValidator methodValidator) {
        this.methodValidator = methodValidator;
    }

    public @Nullable Object invokeForRequest(NativeWebRequest request, @Nullable ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        @Nullable Object[] args = this.getMethodArgumentValues(request, mavContainer, providedArgs);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Arguments: " + Arrays.toString(args)));
        }
        if (this.shouldValidateArguments() && this.methodValidator != null) {
            this.methodValidator.applyArgumentValidation(this.getBean(), this.getBridgedMethod(), this.getMethodParameters(), args, (Class[])this.getValidationGroups());
        }
        Object returnValue = this.doInvoke(args);
        if (this.shouldValidateReturnValue() && this.methodValidator != null) {
            this.methodValidator.applyReturnValueValidation(this.getBean(), this.getBridgedMethod(), this.getReturnType(), returnValue, (Class[])this.getValidationGroups());
        }
        return returnValue;
    }

    protected @Nullable Object[] getMethodArgumentValues(NativeWebRequest request, @Nullable ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] parameters = this.getMethodParameters();
        if (ObjectUtils.isEmpty((Object[])parameters)) {
            return EMPTY_ARGS;
        }
        @Nullable Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            args[i] = InvocableHandlerMethod.findProvidedArgument((MethodParameter)parameter, (Object[])providedArgs);
            if (args[i] != null) continue;
            if (parameter.getParameterType().equals(HandlerMethod.class) && parameter.isOptional()) {
                args[i] = null;
                continue;
            }
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                throw new IllegalStateException(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, (String)"No suitable resolver"));
            }
            try {
                args[i] = this.resolvers.resolveArgument((MethodParameter)parameter, mavContainer, request, this.dataBinderFactory);
                continue;
            }
            catch (Exception ex) {
                String exMsg;
                if (logger.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(parameter.getExecutable().toGenericString())) {
                    logger.debug((Object)InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, (String)exMsg));
                }
                throw ex;
            }
        }
        return args;
    }

    protected @Nullable Object doInvoke(Object ... args) throws Exception {
        Method method = this.getBridgedMethod();
        try {
            if (KOTLIN_REFLECT_PRESENT && KotlinDetector.isKotlinType(method.getDeclaringClass())) {
                if (KotlinDetector.isSuspendingFunction((Method)method)) {
                    return this.invokeSuspendingFunction(method, this.getBean(), args);
                }
                return KotlinDelegate.invokeFunction(method, this.getBean(), args);
            }
            return method.invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(method, this.getBean(), args);
            String text = ex.getMessage() == null || ex.getCause() instanceof NullPointerException ? "Illegal argument" : ex.getMessage();
            throw new IllegalStateException(this.formatInvokeError(text, args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getCause();
            if (targetException instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)targetException;
                throw runtimeException;
            }
            if (targetException instanceof Error) {
                Error error = (Error)targetException;
                throw error;
            }
            if (targetException instanceof Exception) {
                Exception exception = (Exception)targetException;
                throw exception;
            }
            throw new IllegalStateException(this.formatInvokeError("Invocation failure", args), targetException);
        }
    }

    protected Object invokeSuspendingFunction(Method method, Object target, @Nullable Object[] args) {
        Publisher publisher;
        Publisher result = CoroutinesUtils.invokeSuspendingFunction((Method)method, (Object)target, (Object[])args);
        if (result instanceof Mono) {
            Mono mono = (Mono)result;
            publisher = mono.handle(KotlinDelegate::handleResult);
        } else {
            publisher = result;
        }
        return publisher;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static @Nullable Object invokeFunction(Method method, Object target, @Nullable Object[] args) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
            if (function == null) {
                return method.invoke(target, args);
            }
            if (!KCallablesJvm.isAccessible((KCallable)function)) {
                KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
            }
            HashMap argMap = CollectionUtils.newHashMap((int)(args.length + 1));
            int index = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        Object arg = args[index];
                        if (!parameter.isOptional() || arg != null) {
                            KClass kClass;
                            KClassifier kClassifier;
                            KType type = parameter.getType();
                            if ((!type.isMarkedNullable() || arg != null) && (kClassifier = type.getClassifier()) instanceof KClass && KotlinDetector.isInlineClass((Class)JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)kClassifier)))) {
                                arg = KotlinDelegate.box(kClass, arg);
                            }
                            argMap.put(parameter, arg);
                        }
                        ++index;
                    }
                }
            }
            Object result = function.callBy((Map)argMap);
            if (result != null && KotlinDetector.isInlineClass(result.getClass())) {
                result = KotlinDelegate.unbox(result);
            }
            return result == Unit.INSTANCE ? null : result;
        }

        private static Object box(KClass<?> kClass, @Nullable Object arg) {
            KClass parameterClass;
            KClassifier kClassifier;
            KFunction constructor = Objects.requireNonNull(KClasses.getPrimaryConstructor(kClass));
            KType type = ((KParameter)constructor.getParameters().get(0)).getType();
            if ((!type.isMarkedNullable() || arg != null) && (kClassifier = type.getClassifier()) instanceof KClass && KotlinDetector.isInlineClass((Class)JvmClassMappingKt.getJavaClass((KClass)(parameterClass = (KClass)kClassifier)))) {
                arg = KotlinDelegate.box(parameterClass, arg);
            }
            if (!KCallablesJvm.isAccessible((KCallable)constructor)) {
                KCallablesJvm.setAccessible((KCallable)constructor, (boolean)true);
            }
            return constructor.call(new Object[]{arg});
        }

        private static void handleResult(Object result, SynchronousSink<Object> sink) {
            if (KotlinDetector.isInlineClass(result.getClass())) {
                try {
                    Object unboxed = KotlinDelegate.unbox(result);
                    if (unboxed != Unit.INSTANCE) {
                        sink.next(unboxed);
                    }
                    sink.complete();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    sink.error((Throwable)ex);
                }
            } else {
                sink.next(result);
                sink.complete();
            }
        }

        private static Object unbox(Object result) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            Object unboxed = result.getClass().getDeclaredMethod("unbox-impl", new Class[0]).invoke(result, new Object[0]);
            if (KotlinDetector.isInlineClass(unboxed.getClass())) {
                return KotlinDelegate.unbox(unboxed);
            }
            return unboxed;
        }
    }
}

