/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.http.CacheControl;
import org.springframework.http.ContentDisposition;
import org.springframework.http.ETag;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.ReadOnlyHttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class HttpHeaders
implements Serializable {
    private static final long serialVersionUID = -8578554704772377436L;
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_PATCH = "Accept-Patch";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String AGE = "Age";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LINK = "Link";
    public static final String LOCATION = "Location";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORIGIN = "Origin";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String TE = "TE";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final HttpHeaders EMPTY = new ReadOnlyHttpHeaders((MultiValueMap<String, String>)new LinkedMultiValueMap());
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
    private static final ZoneId GMT = ZoneId.of("GMT");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(GMT);
    private static final DateTimeFormatter[] DATE_PARSERS = new DateTimeFormatter[]{DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy", Locale.US).withZone(GMT)};
    final MultiValueMap<String, String> headers;

    public HttpHeaders() {
        this((MultiValueMap<String, String>)CollectionUtils.toMultiValueMap((Map)new LinkedCaseInsensitiveMap(8, Locale.ROOT)));
    }

    public HttpHeaders(MultiValueMap<String, String> headers) {
        Assert.notNull(headers, (String)"MultiValueMap must not be null");
        if (headers == EMPTY) {
            this.headers = CollectionUtils.toMultiValueMap((Map)new LinkedCaseInsensitiveMap(8, Locale.ENGLISH));
        } else if (headers instanceof HttpHeaders) {
            MultiValueMap<String, String> multiValueMap;
            HttpHeaders httpHeaders = (HttpHeaders)headers;
            while ((multiValueMap = httpHeaders.headers) instanceof HttpHeaders) {
                HttpHeaders wrapped;
                httpHeaders = wrapped = (HttpHeaders)multiValueMap;
            }
            this.headers = httpHeaders.headers;
        } else {
            this.headers = headers;
        }
    }

    public HttpHeaders(HttpHeaders httpHeaders) {
        Assert.notNull((Object)httpHeaders, (String)"HttpHeaders must not be null");
        if (httpHeaders == EMPTY) {
            this.headers = CollectionUtils.toMultiValueMap((Map)new LinkedCaseInsensitiveMap(8, Locale.ENGLISH));
        } else {
            MultiValueMap<String, String> multiValueMap;
            while ((multiValueMap = httpHeaders.headers) instanceof HttpHeaders) {
                HttpHeaders wrapped;
                httpHeaders = wrapped = (HttpHeaders)multiValueMap;
            }
            this.headers = httpHeaders.headers;
        }
    }

    public List<String> getOrEmpty(String headerName) {
        return this.getOrDefault(headerName, Collections.emptyList());
    }

    public List<String> getOrDefault(String headerName, List<String> defaultValue) {
        List<String> values = this.get(headerName);
        return values != null ? values : defaultValue;
    }

    public void setAccept(List<MediaType> acceptableMediaTypes) {
        this.set(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public List<MediaType> getAccept() {
        return MediaType.parseMediaTypes(this.get(ACCEPT));
    }

    public void setAcceptLanguage(List<Locale.LanguageRange> languages) {
        Assert.notNull(languages, (String)"LanguageRange List must not be null");
        DecimalFormat decimal = new DecimalFormat("0.0", DECIMAL_FORMAT_SYMBOLS);
        List<String> values = languages.stream().map(range -> range.getWeight() == 1.0 ? range.getRange() : range.getRange() + ";q=" + decimal.format(range.getWeight())).toList();
        this.set(ACCEPT_LANGUAGE, this.toCommaDelimitedString(values));
    }

    public List<Locale.LanguageRange> getAcceptLanguage() {
        String value = this.getFirst(ACCEPT_LANGUAGE);
        if (StringUtils.hasText((String)value)) {
            try {
                return Locale.LanguageRange.parse(value);
            }
            catch (IllegalArgumentException ignored) {
                Object[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = StringUtils.trimTrailingCharacter((String)tokens[i], (char)';');
                }
                value = StringUtils.arrayToCommaDelimitedString((Object[])tokens);
                return Locale.LanguageRange.parse(value);
            }
        }
        return Collections.emptyList();
    }

    public void setAcceptLanguageAsLocales(List<Locale> locales) {
        this.setAcceptLanguage(locales.stream().map(locale -> new Locale.LanguageRange(locale.toLanguageTag())).toList());
    }

    public List<Locale> getAcceptLanguageAsLocales() {
        List<Locale.LanguageRange> ranges = this.getAcceptLanguage();
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Locale> locales = new ArrayList<Locale>(ranges.size());
        for (Locale.LanguageRange range : ranges) {
            if (range.getRange().startsWith("*")) continue;
            locales.add(Locale.forLanguageTag(range.getRange()));
        }
        return locales;
    }

    public void setAcceptPatch(List<MediaType> mediaTypes) {
        this.set(ACCEPT_PATCH, MediaType.toString(mediaTypes));
    }

    public List<MediaType> getAcceptPatch() {
        return MediaType.parseMediaTypes(this.get(ACCEPT_PATCH));
    }

    public void setAccessControlAllowCredentials(boolean allowCredentials) {
        this.set(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.toString(allowCredentials));
    }

    public boolean getAccessControlAllowCredentials() {
        return Boolean.parseBoolean(this.getFirst(ACCESS_CONTROL_ALLOW_CREDENTIALS));
    }

    public void setAccessControlAllowHeaders(List<String> allowedHeaders) {
        this.set(ACCESS_CONTROL_ALLOW_HEADERS, this.toCommaDelimitedString(allowedHeaders));
    }

    public List<String> getAccessControlAllowHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_ALLOW_HEADERS);
    }

    public void setAccessControlAllowMethods(List<HttpMethod> allowedMethods) {
        this.set(ACCESS_CONTROL_ALLOW_METHODS, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public List<HttpMethod> getAccessControlAllowMethods() {
        String value = this.getFirst(ACCESS_CONTROL_ALLOW_METHODS);
        if (value != null) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
            ArrayList<HttpMethod> result = new ArrayList<HttpMethod>(tokens.length);
            for (String token : tokens) {
                HttpMethod method = HttpMethod.valueOf(token);
                result.add(method);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setAccessControlAllowOrigin(@Nullable String allowedOrigin) {
        this.setOrRemove(ACCESS_CONTROL_ALLOW_ORIGIN, allowedOrigin);
    }

    public @Nullable String getAccessControlAllowOrigin() {
        return this.getFieldValues(ACCESS_CONTROL_ALLOW_ORIGIN);
    }

    public void setAccessControlExposeHeaders(List<String> exposedHeaders) {
        this.set(ACCESS_CONTROL_EXPOSE_HEADERS, this.toCommaDelimitedString(exposedHeaders));
    }

    public List<String> getAccessControlExposeHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_EXPOSE_HEADERS);
    }

    public void setAccessControlMaxAge(Duration maxAge) {
        this.set(ACCESS_CONTROL_MAX_AGE, Long.toString(maxAge.getSeconds()));
    }

    public void setAccessControlMaxAge(long maxAge) {
        this.set(ACCESS_CONTROL_MAX_AGE, Long.toString(maxAge));
    }

    public long getAccessControlMaxAge() {
        String value = this.getFirst(ACCESS_CONTROL_MAX_AGE);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setAccessControlRequestHeaders(List<String> requestHeaders) {
        this.set(ACCESS_CONTROL_REQUEST_HEADERS, this.toCommaDelimitedString(requestHeaders));
    }

    public List<String> getAccessControlRequestHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_REQUEST_HEADERS);
    }

    public void setAccessControlRequestMethod(@Nullable HttpMethod requestMethod) {
        this.setOrRemove(ACCESS_CONTROL_REQUEST_METHOD, requestMethod != null ? requestMethod.name() : null);
    }

    public @Nullable HttpMethod getAccessControlRequestMethod() {
        String requestMethod = this.getFirst(ACCESS_CONTROL_REQUEST_METHOD);
        if (requestMethod != null) {
            return HttpMethod.valueOf(requestMethod);
        }
        return null;
    }

    public void setAcceptCharset(List<Charset> acceptableCharsets) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Charset charset : acceptableCharsets) {
            joiner.add(charset.name().toLowerCase(Locale.ROOT));
        }
        this.set(ACCEPT_CHARSET, joiner.toString());
    }

    public List<Charset> getAcceptCharset() {
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
            ArrayList<Charset> result = new ArrayList<Charset>(tokens.length);
            for (String token : tokens) {
                int paramIdx = token.indexOf(59);
                String charsetName = paramIdx == -1 ? token : token.substring(0, paramIdx);
                if (charsetName.equals("*")) continue;
                result.add(Charset.forName(charsetName));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setAllow(Set<HttpMethod> allowedMethods) {
        this.set(ALLOW, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (StringUtils.hasLength((String)value)) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
            LinkedHashSet result = CollectionUtils.newLinkedHashSet((int)tokens.length);
            for (String token : tokens) {
                HttpMethod method = HttpMethod.valueOf(token);
                result.add(method);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void setBasicAuth(String username, String password) {
        this.setBasicAuth(username, password, null);
    }

    public void setBasicAuth(String username, String password, @Nullable Charset charset) {
        this.setBasicAuth(HttpHeaders.encodeBasicAuth(username, password, charset));
    }

    public void setBasicAuth(String encodedCredentials) {
        Assert.hasText((String)encodedCredentials, (String)"'encodedCredentials' must not be null or blank");
        this.set(AUTHORIZATION, "Basic " + encodedCredentials);
    }

    public void setBearerAuth(String token) {
        this.set(AUTHORIZATION, "Bearer " + token);
    }

    public void setCacheControl(CacheControl cacheControl) {
        this.setOrRemove(CACHE_CONTROL, cacheControl.getHeaderValue());
    }

    public void setCacheControl(@Nullable String cacheControl) {
        this.setOrRemove(CACHE_CONTROL, cacheControl);
    }

    public @Nullable String getCacheControl() {
        return this.getFieldValues(CACHE_CONTROL);
    }

    public void setConnection(String connection) {
        this.set(CONNECTION, connection);
    }

    public void setConnection(List<String> connection) {
        this.set(CONNECTION, this.toCommaDelimitedString(connection));
    }

    public List<String> getConnection() {
        return this.getValuesAsList(CONNECTION);
    }

    public void setContentDispositionFormData(String name, @Nullable String filename) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        ContentDisposition.Builder disposition = ContentDisposition.formData().name(name);
        if (StringUtils.hasText((String)filename)) {
            disposition.filename(filename);
        }
        this.setContentDisposition(disposition.build());
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        this.set(CONTENT_DISPOSITION, contentDisposition.toString());
    }

    public ContentDisposition getContentDisposition() {
        String contentDisposition = this.getFirst(CONTENT_DISPOSITION);
        if (StringUtils.hasText((String)contentDisposition)) {
            return ContentDisposition.parse(contentDisposition);
        }
        return ContentDisposition.empty();
    }

    public void setContentLanguage(@Nullable Locale locale) {
        this.setOrRemove(CONTENT_LANGUAGE, locale != null ? locale.toLanguageTag() : null);
    }

    public @Nullable Locale getContentLanguage() {
        return this.getValuesAsList(CONTENT_LANGUAGE).stream().findFirst().map(Locale::forLanguageTag).orElse(null);
    }

    public void setContentLength(long contentLength) {
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content-Length must be a non-negative number");
        }
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(@Nullable MediaType mediaType) {
        if (mediaType != null) {
            Assert.isTrue((!mediaType.isWildcardType() ? 1 : 0) != 0, (String)"Content-Type cannot contain wildcard type '*'");
            Assert.isTrue((!mediaType.isWildcardSubtype() ? 1 : 0) != 0, (String)"Content-Type cannot contain wildcard subtype '*'");
            this.set(CONTENT_TYPE, mediaType.toString());
        } else {
            this.remove(CONTENT_TYPE);
        }
    }

    public @Nullable MediaType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return StringUtils.hasLength((String)value) ? MediaType.parseMediaType(value) : null;
    }

    public void setDate(ZonedDateTime date) {
        this.setZonedDateTime(DATE, date);
    }

    public void setDate(Instant date) {
        this.setInstant(DATE, date);
    }

    public void setDate(long date) {
        this.setDate(DATE, date);
    }

    public long getDate() {
        return this.getFirstDate(DATE);
    }

    public void setETag(@Nullable String tag) {
        if (tag != null) {
            this.set(ETAG, ETag.quoteETagIfNecessary(tag));
        } else {
            this.remove(ETAG);
        }
    }

    public @Nullable String getETag() {
        return this.getFirst(ETAG);
    }

    public void setExpires(ZonedDateTime expires) {
        this.setZonedDateTime(EXPIRES, expires);
    }

    public void setExpires(Instant expires) {
        this.setInstant(EXPIRES, expires);
    }

    public void setExpires(long expires) {
        this.setDate(EXPIRES, expires);
    }

    public long getExpires() {
        return this.getFirstDate(EXPIRES, false);
    }

    public void setHost(@Nullable InetSocketAddress host) {
        if (host != null) {
            Object value = host.getHostString();
            int port = host.getPort();
            if (port != 0) {
                value = (String)value + ":" + port;
            }
            this.set(HOST, (String)value);
        } else {
            this.remove(HOST);
        }
    }

    public @Nullable InetSocketAddress getHost() {
        int separator;
        String value = this.getFirst(HOST);
        if (value == null) {
            return null;
        }
        String host = null;
        int port = 0;
        int n = separator = value.startsWith("[") ? value.indexOf(58, value.indexOf(93)) : value.lastIndexOf(58);
        if (separator != -1) {
            host = value.substring(0, separator);
            String portString = value.substring(separator + 1);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (host == null) {
            host = value;
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public void setIfMatch(String ifMatch) {
        this.set(IF_MATCH, ifMatch);
    }

    public void setIfMatch(List<String> ifMatchList) {
        this.set(IF_MATCH, this.toCommaDelimitedString(ifMatchList));
    }

    public List<String> getIfMatch() {
        return this.getETagValuesAsList(IF_MATCH);
    }

    public void setIfModifiedSince(ZonedDateTime ifModifiedSince) {
        this.setZonedDateTime(IF_MODIFIED_SINCE, ifModifiedSince.withZoneSameInstant(GMT));
    }

    public void setIfModifiedSince(Instant ifModifiedSince) {
        this.setInstant(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.setDate(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    public long getIfModifiedSince() {
        return this.getFirstDate(IF_MODIFIED_SINCE, false);
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.set(IF_NONE_MATCH, ifNoneMatch);
    }

    public void setIfNoneMatch(List<String> ifNoneMatchList) {
        this.set(IF_NONE_MATCH, this.toCommaDelimitedString(ifNoneMatchList));
    }

    public List<String> getIfNoneMatch() {
        return this.getETagValuesAsList(IF_NONE_MATCH);
    }

    public void setIfUnmodifiedSince(ZonedDateTime ifUnmodifiedSince) {
        this.setZonedDateTime(IF_UNMODIFIED_SINCE, ifUnmodifiedSince.withZoneSameInstant(GMT));
    }

    public void setIfUnmodifiedSince(Instant ifUnmodifiedSince) {
        this.setInstant(IF_UNMODIFIED_SINCE, ifUnmodifiedSince);
    }

    public void setIfUnmodifiedSince(long ifUnmodifiedSince) {
        this.setDate(IF_UNMODIFIED_SINCE, ifUnmodifiedSince);
    }

    public long getIfUnmodifiedSince() {
        return this.getFirstDate(IF_UNMODIFIED_SINCE, false);
    }

    public void setLastModified(ZonedDateTime lastModified) {
        this.setZonedDateTime(LAST_MODIFIED, lastModified.withZoneSameInstant(GMT));
    }

    public void setLastModified(Instant lastModified) {
        this.setInstant(LAST_MODIFIED, lastModified);
    }

    public void setLastModified(long lastModified) {
        this.setDate(LAST_MODIFIED, lastModified);
    }

    public long getLastModified() {
        return this.getFirstDate(LAST_MODIFIED, false);
    }

    public void setLocation(@Nullable URI location) {
        this.setOrRemove(LOCATION, location != null ? location.toASCIIString() : null);
    }

    public @Nullable URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public void setOrigin(@Nullable String origin) {
        this.setOrRemove(ORIGIN, origin);
    }

    public @Nullable String getOrigin() {
        return this.getFirst(ORIGIN);
    }

    public void setPragma(@Nullable String pragma) {
        this.setOrRemove(PRAGMA, pragma);
    }

    public @Nullable String getPragma() {
        return this.getFirst(PRAGMA);
    }

    public void setRange(List<HttpRange> ranges) {
        String value = HttpRange.toString(ranges);
        this.set(RANGE, value);
    }

    public List<HttpRange> getRange() {
        String value = this.getFirst(RANGE);
        return HttpRange.parseRanges(value);
    }

    public void setUpgrade(@Nullable String upgrade) {
        this.setOrRemove(UPGRADE, upgrade);
    }

    public @Nullable String getUpgrade() {
        return this.getFirst(UPGRADE);
    }

    public void setVary(List<String> requestHeaders) {
        this.set(VARY, this.toCommaDelimitedString(requestHeaders));
    }

    public List<String> getVary() {
        return this.getValuesAsList(VARY);
    }

    public void setZonedDateTime(String headerName, ZonedDateTime date) {
        this.set(headerName, DATE_FORMATTER.format(date));
    }

    public void setInstant(String headerName, Instant date) {
        this.setZonedDateTime(headerName, ZonedDateTime.ofInstant(date, GMT));
    }

    public void setDate(String headerName, long date) {
        this.setInstant(headerName, Instant.ofEpochMilli(date));
    }

    public long getFirstDate(String headerName) {
        return this.getFirstDate(headerName, true);
    }

    private long getFirstDate(String headerName, boolean rejectInvalid) {
        ZonedDateTime zonedDateTime = this.getFirstZonedDateTime(headerName, rejectInvalid);
        return zonedDateTime != null ? zonedDateTime.toInstant().toEpochMilli() : -1L;
    }

    public @Nullable ZonedDateTime getFirstZonedDateTime(String headerName) {
        return this.getFirstZonedDateTime(headerName, true);
    }

    private @Nullable ZonedDateTime getFirstZonedDateTime(String headerName, boolean rejectInvalid) {
        String headerValue = this.getFirst(headerName);
        if (headerValue == null) {
            return null;
        }
        if (headerValue.length() >= 3) {
            int parametersIndex = headerValue.indexOf(59);
            if (parametersIndex != -1) {
                headerValue = headerValue.substring(0, parametersIndex);
            }
            for (DateTimeFormatter dateFormatter : DATE_PARSERS) {
                try {
                    return ZonedDateTime.parse(headerValue, dateFormatter);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        if (rejectInvalid) {
            throw new IllegalArgumentException("Cannot parse date value \"" + headerValue + "\" for \"" + headerName + "\" header");
        }
        return null;
    }

    public List<String> getValuesAsList(String headerName) {
        List<String> values = this.get(headerName);
        if (values != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String value : values) {
                if (value == null) continue;
                result.addAll(HttpHeaders.tokenizeQuoted(value));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<String> tokenizeQuoted(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean quoted = false;
        boolean trim = true;
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                if (builder.isEmpty()) {
                    quoted = true;
                    continue;
                }
                if (quoted) {
                    quoted = false;
                    trim = false;
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (ch == '\\' && quoted && i < str.length() - 1) {
                builder.append(str.charAt(++i));
                continue;
            }
            if (ch == ',' && !quoted) {
                HttpHeaders.addToken(builder, tokens, trim);
                builder.setLength(0);
                trim = false;
                continue;
            }
            if (!quoted && (builder.isEmpty() || !trim) && Character.isWhitespace(ch)) continue;
            builder.append(ch);
        }
        if (!builder.isEmpty()) {
            HttpHeaders.addToken(builder, tokens, trim);
        }
        return tokens;
    }

    private static void addToken(StringBuilder builder, List<String> tokens, boolean trim) {
        String token = builder.toString();
        if (trim) {
            token = token.trim();
        }
        if (!token.isEmpty()) {
            tokens.add(token);
        }
    }

    public void clearContentHeaders() {
        this.headers.remove((Object)CONTENT_DISPOSITION);
        this.headers.remove((Object)CONTENT_ENCODING);
        this.headers.remove((Object)CONTENT_LANGUAGE);
        this.headers.remove((Object)CONTENT_LENGTH);
        this.headers.remove((Object)CONTENT_LOCATION);
        this.headers.remove((Object)CONTENT_RANGE);
        this.headers.remove((Object)CONTENT_TYPE);
    }

    protected List<String> getETagValuesAsList(String name) {
        List<String> values = this.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            if (value == null) continue;
            List<ETag> tags = ETag.parse(value);
            Assert.notEmpty(tags, (String)("Could not parse header '" + name + "' with value '" + value + "'"));
            for (ETag tag : tags) {
                result.add(tag.formattedTag());
            }
        }
        return result;
    }

    protected @Nullable String getFieldValues(String headerName) {
        List<String> headerValues = this.get(headerName);
        return headerValues != null ? this.toCommaDelimitedString(headerValues) : null;
    }

    protected String toCommaDelimitedString(List<String> headerValues) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String val : headerValues) {
            if (val == null) continue;
            joiner.add(val);
        }
        return joiner.toString();
    }

    private void setOrRemove(String headerName, @Nullable String headerValue) {
        if (headerValue != null) {
            this.set(headerName, headerValue);
        } else {
            this.remove(headerName);
        }
    }

    public @Nullable String getFirst(String headerName) {
        return (String)this.headers.getFirst((Object)headerName);
    }

    public void add(String headerName, @Nullable String headerValue) {
        this.headers.add((Object)headerName, (Object)headerValue);
    }

    public void addAll(String headerName, List<? extends String> headerValues) {
        this.headers.addAll((Object)headerName, headerValues);
    }

    public void addAll(HttpHeaders headers) {
        this.headers.addAll(headers.headers);
    }

    public void set(String headerName, @Nullable String headerValue) {
        this.headers.set((Object)headerName, (Object)headerValue);
    }

    public void setAll(Map<String, String> values) {
        this.headers.setAll(values);
    }

    public Map<String, String> toSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public Map<String, String> asSingleValueMap() {
        return this.headers.asSingleValueMap();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public MultiValueMap<String, String> asMultiValueMap() {
        return this.headers;
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsHeader(String headerName) {
        return this.headers.containsKey((Object)headerName);
    }

    public boolean hasHeaderValues(String headerName, List<String> values) {
        return ObjectUtils.nullSafeEquals((Object)this.headers.get((Object)headerName), values);
    }

    public boolean containsHeaderValue(String headerName, String value) {
        List values = (List)this.headers.get((Object)headerName);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    public @Nullable List<String> get(String headerName) {
        return (List)this.headers.get((Object)headerName);
    }

    public @Nullable List<String> put(String headerName, List<String> headerValues) {
        return (List)this.headers.put((Object)headerName, headerValues);
    }

    public @Nullable List<String> putIfAbsent(String headerName, List<String> headerValues) {
        return (List)this.headers.putIfAbsent((Object)headerName, headerValues);
    }

    public void putAll(HttpHeaders headers) {
        this.headers.putAll(headers.headers);
    }

    public void putAll(Map<? extends String, ? extends List<String>> headers) {
        this.headers.putAll(headers);
    }

    public @Nullable List<String> remove(String key) {
        return (List)this.headers.remove((Object)key);
    }

    public void clear() {
        this.headers.clear();
    }

    public int size() {
        return this.headers.size();
    }

    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.headerSet().forEach((? super T e) -> action.accept((String)e.getKey(), (List<String>)e.getValue()));
    }

    public Set<Map.Entry<String, List<String>>> headerSet() {
        return new CaseInsensitiveEntrySet(this.headers);
    }

    public Set<String> headerNames() {
        return new CaseInsensitiveHeaderNameSet(this.headers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof HttpHeaders)) return false;
        HttpHeaders that = (HttpHeaders)other;
        if (!HttpHeaders.unwrap(this).equals(HttpHeaders.unwrap(that))) return false;
        return true;
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this.headers);
    }

    public static HttpHeaders readOnlyHttpHeaders(MultiValueMap<String, String> headers) {
        HttpHeaders httpHeaders;
        if (headers instanceof HttpHeaders) {
            HttpHeaders httpHeaders2 = (HttpHeaders)headers;
            httpHeaders = HttpHeaders.readOnlyHttpHeaders(httpHeaders2);
        } else {
            httpHeaders = new ReadOnlyHttpHeaders(headers);
        }
        return httpHeaders;
    }

    public static HttpHeaders readOnlyHttpHeaders(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null");
        return headers instanceof ReadOnlyHttpHeaders ? headers : new ReadOnlyHttpHeaders(headers.headers);
    }

    public static String formatHeaders(MultiValueMap<String, String> headers) {
        CaseInsensitiveHeaderNameSet headerNames = new CaseInsensitiveHeaderNameSet(headers);
        Object suffix = "]";
        if (headerNames.size() != headers.size()) {
            suffix = "] with native header names " + String.valueOf(headers.keySet());
        }
        return headerNames.stream().map(headerName -> {
            List values = (List)headers.get(headerName);
            Assert.notNull((Object)values, (String)("Expected at least one value for header " + headerName));
            return headerName + ":" + (String)(values.size() == 1 ? "\"" + (String)values.get(0) + "\"" : values.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")));
        }).collect(Collectors.joining(", ", "[", (CharSequence)suffix));
    }

    public static String encodeBasicAuth(String username, String password, @Nullable Charset charset) {
        CharsetEncoder encoder;
        Assert.notNull((Object)username, (String)"Username must not be null");
        Assert.doesNotContain((String)username, (String)":", (String)"Username must not contain a colon");
        Assert.notNull((Object)password, (String)"Password must not be null");
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        if (!(encoder = charset.newEncoder()).canEncode(username) || !encoder.canEncode(password)) {
            throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to " + charset.displayName());
        }
        String credentialsString = username + ":" + password;
        byte[] encodedBytes = Base64.getEncoder().encode(credentialsString.getBytes(charset));
        return new String(encodedBytes, charset);
    }

    private static MultiValueMap<String, String> unwrap(HttpHeaders headers) {
        MultiValueMap<String, String> multiValueMap;
        while ((multiValueMap = headers.headers) instanceof HttpHeaders) {
            HttpHeaders httpHeaders;
            headers = httpHeaders = (HttpHeaders)multiValueMap;
        }
        return headers.headers;
    }

    static String formatDate(long date) {
        Instant instant = Instant.ofEpochMilli(date);
        ZonedDateTime time = ZonedDateTime.ofInstant(instant, GMT);
        return DATE_FORMATTER.format(time);
    }

    private static final class CaseInsensitiveEntrySet
    extends AbstractSet<Map.Entry<String, List<String>>> {
        private final MultiValueMap<String, String> headers;
        private final CaseInsensitiveHeaderNameSet nameSet;

        public CaseInsensitiveEntrySet(MultiValueMap<String, String> headers) {
            this.headers = headers;
            this.nameSet = new CaseInsensitiveHeaderNameSet(headers);
        }

        @Override
        public Iterator<Map.Entry<String, List<String>>> iterator() {
            return new CaseInsensitiveIterator(this.nameSet.iterator());
        }

        @Override
        public int size() {
            return this.nameSet.size();
        }

        private final class CaseInsensitiveIterator
        implements Iterator<Map.Entry<String, List<String>>> {
            private final Iterator<String> namesIterator;

            public CaseInsensitiveIterator(Iterator<String> namesIterator) {
                this.namesIterator = namesIterator;
            }

            @Override
            public boolean hasNext() {
                return this.namesIterator.hasNext();
            }

            @Override
            public Map.Entry<String, List<String>> next() {
                return new CaseInsensitiveEntry(this.namesIterator.next());
            }

            @Override
            public void remove() {
                this.namesIterator.remove();
            }
        }

        private final class CaseInsensitiveEntry
        implements Map.Entry<String, List<String>> {
            private final String key;

            CaseInsensitiveEntry(String key) {
                this.key = key;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public List<String> getValue() {
                return Objects.requireNonNull((List)CaseInsensitiveEntrySet.this.headers.get((Object)this.key));
            }

            @Override
            public List<String> setValue(List<String> value) {
                List previousValues = Objects.requireNonNull((List)CaseInsensitiveEntrySet.this.headers.get((Object)this.key));
                CaseInsensitiveEntrySet.this.headers.put((Object)this.key, value);
                return previousValues;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry that = (Map.Entry)o;
                return ObjectUtils.nullSafeEquals((Object)this.getKey(), that.getKey()) && ObjectUtils.nullSafeEquals((Object)this.getValue(), that.getValue());
            }

            @Override
            public int hashCode() {
                return ObjectUtils.nullSafeHash((Object[])new Object[]{this.getKey(), this.getValue()});
            }
        }
    }

    private static final class CaseInsensitiveHeaderNameSet
    extends AbstractSet<String> {
        private static final Object VALUE = new Object();
        private final MultiValueMap<String, String> headers;
        private final Map<String, Object> deduplicatedNames;

        public CaseInsensitiveHeaderNameSet(MultiValueMap<String, String> headers) {
            this.headers = headers;
            this.deduplicatedNames = new LinkedCaseInsensitiveMap(headers.size(), Locale.ROOT);
            for (String header : headers.keySet()) {
                if (this.deduplicatedNames.containsKey(header)) continue;
                this.deduplicatedNames.put(header, VALUE);
            }
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(this.headers, this.deduplicatedNames);
        }

        @Override
        public int size() {
            return this.deduplicatedNames.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.headers.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.headers.remove(o) != null && this.deduplicatedNames.remove(o) != null;
        }

        @Override
        public void clear() {
            this.headers.clear();
            this.deduplicatedNames.clear();
        }
    }

    private static class HeaderNamesIterator
    implements Iterator<String> {
        private @Nullable String currentName;
        private final MultiValueMap<String, String> headers;
        private final Iterator<String> namesIterator;

        public HeaderNamesIterator(MultiValueMap<String, String> headers, Map<String, Object> caseInsensitiveNames) {
            this.headers = headers;
            this.namesIterator = caseInsensitiveNames.keySet().iterator();
            this.currentName = null;
        }

        @Override
        public boolean hasNext() {
            return this.namesIterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.namesIterator.next();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!this.headers.containsKey((Object)this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            this.headers.remove((Object)this.currentName);
        }
    }
}

