/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.ReactorClientHttpRequest;
import org.springframework.http.support.Netty4HeadersAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

final class ReactorClientHttpResponse
implements ClientHttpResponse {
    private final HttpClientResponse response;
    private final Connection connection;
    private final HttpHeaders headers;
    private final Duration readTimeout;
    @Nullable
    private volatile InputStream body;

    public ReactorClientHttpResponse(HttpClientResponse response, Connection connection, Duration readTimeout) {
        this.response = response;
        this.connection = connection;
        this.readTimeout = readTimeout;
        this.headers = HttpHeaders.readOnlyHttpHeaders(new Netty4HeadersAdapter(response.responseHeaders()));
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    public String getStatusText() {
        return this.response.status().reasonPhrase();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        InputStream body2 = this.body;
        if (body2 != null) {
            return body2;
        }
        try {
            body2 = (InputStream)this.connection.inbound().receive().aggregate().asInputStream().block(this.readTimeout);
        }
        catch (RuntimeException ex) {
            throw ReactorClientHttpRequest.convertException(ex);
        }
        if (body2 == null) {
            body2 = InputStream.nullInputStream();
        }
        this.body = body2;
        return body2;
    }

    @Override
    public void close() {
        try {
            InputStream body2 = this.getBody();
            StreamUtils.drain((InputStream)body2);
            body2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

