/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.client.DefaultRestClientBuilder;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

public interface RestClient {
    public RequestHeadersUriSpec<?> get();

    public RequestHeadersUriSpec<?> head();

    public RequestBodyUriSpec post();

    public RequestBodyUriSpec put();

    public RequestBodyUriSpec patch();

    public RequestHeadersUriSpec<?> delete();

    public RequestHeadersUriSpec<?> options();

    public RequestBodyUriSpec method(HttpMethod var1);

    public Builder mutate();

    public static RestClient create() {
        return new DefaultRestClientBuilder().build();
    }

    public static RestClient create(String baseUrl) {
        return new DefaultRestClientBuilder().baseUrl(baseUrl).build();
    }

    public static RestClient create(URI baseUrl) {
        return new DefaultRestClientBuilder().baseUrl(baseUrl).build();
    }

    public static RestClient create(RestTemplate restTemplate) {
        return new DefaultRestClientBuilder(restTemplate).build();
    }

    public static Builder builder() {
        return new DefaultRestClientBuilder();
    }

    public static Builder builder(RestTemplate restTemplate) {
        return new DefaultRestClientBuilder(restTemplate);
    }

    public static interface Builder {
        public Builder baseUrl(String var1);

        public Builder baseUrl(URI var1);

        public Builder defaultUriVariables(Map<String, ?> var1);

        public Builder uriBuilderFactory(UriBuilderFactory var1);

        public Builder defaultHeader(String var1, String ... var2);

        public Builder defaultHeaders(Consumer<HttpHeaders> var1);

        public Builder defaultRequest(Consumer<RequestHeadersSpec<?>> var1);

        public Builder defaultStatusHandler(Predicate<HttpStatusCode> var1, ResponseSpec.ErrorHandler var2);

        public Builder defaultStatusHandler(ResponseErrorHandler var1);

        public Builder requestInterceptor(ClientHttpRequestInterceptor var1);

        public Builder requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> var1);

        public Builder requestInitializer(ClientHttpRequestInitializer var1);

        public Builder requestInitializers(Consumer<List<ClientHttpRequestInitializer>> var1);

        public Builder requestFactory(ClientHttpRequestFactory var1);

        public Builder messageConverters(Consumer<List<HttpMessageConverter<?>>> var1);

        public Builder observationRegistry(ObservationRegistry var1);

        public Builder observationConvention(ClientRequestObservationConvention var1);

        public Builder apply(Consumer<Builder> var1);

        public Builder clone();

        public RestClient build();
    }

    public static interface RequestBodyUriSpec
    extends RequestBodySpec,
    RequestHeadersUriSpec<RequestBodySpec> {
    }

    public static interface RequestHeadersUriSpec<S extends RequestHeadersSpec<S>>
    extends UriSpec<S>,
    RequestHeadersSpec<S> {
    }

    public static interface ResponseSpec {
        public ResponseSpec onStatus(Predicate<HttpStatusCode> var1, ErrorHandler var2);

        public ResponseSpec onStatus(ResponseErrorHandler var1);

        @Nullable
        public <T> T body(Class<T> var1);

        @Nullable
        public <T> T body(ParameterizedTypeReference<T> var1);

        public <T> ResponseEntity<T> toEntity(Class<T> var1);

        public <T> ResponseEntity<T> toEntity(ParameterizedTypeReference<T> var1);

        public ResponseEntity<Void> toBodilessEntity();

        @FunctionalInterface
        public static interface ErrorHandler {
            public void handle(HttpRequest var1, ClientHttpResponse var2) throws IOException;
        }
    }

    public static interface RequestBodySpec
    extends RequestHeadersSpec<RequestBodySpec> {
        public RequestBodySpec contentLength(long var1);

        public RequestBodySpec contentType(MediaType var1);

        public RequestBodySpec body(Object var1);

        public <T> RequestBodySpec body(T var1, ParameterizedTypeReference<T> var2);

        public RequestBodySpec body(StreamingHttpOutputMessage.Body var1);
    }

    public static interface RequestHeadersSpec<S extends RequestHeadersSpec<S>> {
        public S accept(MediaType ... var1);

        public S acceptCharset(Charset ... var1);

        public S ifModifiedSince(ZonedDateTime var1);

        public S ifNoneMatch(String ... var1);

        public S header(String var1, String ... var2);

        public S headers(Consumer<HttpHeaders> var1);

        public S attribute(String var1, Object var2);

        public S attributes(Consumer<Map<String, Object>> var1);

        public S httpRequest(Consumer<ClientHttpRequest> var1);

        public ResponseSpec retrieve();

        default public <T> T exchange(ExchangeFunction<T> exchangeFunction) {
            return this.exchange(exchangeFunction, true);
        }

        public <T> T exchange(ExchangeFunction<T> var1, boolean var2);

        @FunctionalInterface
        public static interface ExchangeFunction<T> {
            public T exchange(HttpRequest var1, ConvertibleClientHttpResponse var2) throws IOException;
        }

        public static interface ConvertibleClientHttpResponse
        extends ClientHttpResponse {
            @Nullable
            public <T> T bodyTo(Class<T> var1);

            @Nullable
            public <T> T bodyTo(ParameterizedTypeReference<T> var1);
        }
    }

    public static interface UriSpec<S extends RequestHeadersSpec<?>> {
        public S uri(URI var1);

        public S uri(String var1, Object ... var2);

        public S uri(String var1, Map<String, ?> var2);

        public S uri(String var1, Function<UriBuilder, URI> var2);

        public S uri(Function<UriBuilder, URI> var1);
    }
}

