/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.observation.ClientHttpObservationDocumentation;
import org.springframework.http.client.observation.ClientRequestObservationContext;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.http.client.observation.DefaultClientRequestObservationConvention;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.DefaultRestClientBuilder;
import org.springframework.web.client.IntrospectingClientHttpResponse;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientUtils;
import org.springframework.web.client.StatusHandler;
import org.springframework.web.client.UnknownContentTypeException;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

final class DefaultRestClient
implements RestClient {
    private static final Log logger = LogFactory.getLog(DefaultRestClient.class);
    private static final ClientRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultClientRequestObservationConvention();
    private static final String URI_TEMPLATE_ATTRIBUTE = RestClient.class.getName() + ".uriTemplate";
    private final ClientHttpRequestFactory clientRequestFactory;
    @Nullable
    private volatile ClientHttpRequestFactory interceptingRequestFactory;
    @Nullable
    private final List<ClientHttpRequestInitializer> initializers;
    @Nullable
    private final List<ClientHttpRequestInterceptor> interceptors;
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final HttpHeaders defaultHeaders;
    @Nullable
    private final Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest;
    private final List<StatusHandler> defaultStatusHandlers;
    private final DefaultRestClientBuilder builder;
    private final List<HttpMessageConverter<?>> messageConverters;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ClientRequestObservationConvention observationConvention;

    DefaultRestClient(ClientHttpRequestFactory clientRequestFactory, @Nullable List<ClientHttpRequestInterceptor> interceptors, @Nullable List<ClientHttpRequestInitializer> initializers, UriBuilderFactory uriBuilderFactory, @Nullable HttpHeaders defaultHeaders, @Nullable Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest, @Nullable List<StatusHandler> statusHandlers, List<HttpMessageConverter<?>> messageConverters, ObservationRegistry observationRegistry, @Nullable ClientRequestObservationConvention observationConvention, DefaultRestClientBuilder builder) {
        this.clientRequestFactory = clientRequestFactory;
        this.initializers = initializers;
        this.interceptors = interceptors;
        this.uriBuilderFactory = uriBuilderFactory;
        this.defaultHeaders = defaultHeaders;
        this.defaultRequest = defaultRequest;
        this.defaultStatusHandlers = statusHandlers != null ? new ArrayList<StatusHandler>(statusHandlers) : new ArrayList();
        this.messageConverters = messageConverters;
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
        this.builder = builder;
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public RestClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public RestClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public RestClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public RestClient.RequestBodyUriSpec method(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HttpMethod must not be null");
        return this.methodInternal(method);
    }

    private RestClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        DefaultRequestBodyUriSpec spec = new DefaultRequestBodyUriSpec(httpMethod);
        if (this.defaultRequest != null) {
            this.defaultRequest.accept(spec);
        }
        return spec;
    }

    @Override
    public RestClient.Builder mutate() {
        return new DefaultRestClientBuilder(this.builder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T readWithMessageConverters(ClientHttpResponse clientResponse, Runnable callback, Type bodyType, Class<T> bodyClass, @Nullable Observation observation) {
        MediaType contentType = DefaultRestClient.getContentType(clientResponse);
        try (ClientHttpResponse clientHttpResponse = clientResponse;){
            callback.run();
            IntrospectingClientHttpResponse responseWrapper = new IntrospectingClientHttpResponse(clientResponse);
            if (!responseWrapper.hasMessageBody() || responseWrapper.hasEmptyMessageBody()) {
                T t = null;
                return t;
            }
            for (HttpMessageConverter<T> httpMessageConverter : this.messageConverters) {
                Object object;
                if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)httpMessageConverter;
                    if (!genericMessageConverter.canRead(bodyType, null, contentType)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Reading to [" + ResolvableType.forType((Type)bodyType) + "]"));
                    }
                    object = genericMessageConverter.read(bodyType, null, responseWrapper);
                    return (T)object;
                }
                if (httpMessageConverter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartMessageConverter = (SmartHttpMessageConverter)httpMessageConverter;
                    ResolvableType resolvableType = ResolvableType.forType((Type)bodyType);
                    if (!smartMessageConverter.canRead(resolvableType, contentType)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Reading to [" + resolvableType + "]"));
                    }
                    Object t = smartMessageConverter.read(resolvableType, responseWrapper, null);
                    return t;
                }
                if (!httpMessageConverter.canRead(bodyClass, contentType)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reading to [" + bodyClass.getName() + "] as \"" + contentType + "\""));
                }
                object = httpMessageConverter.read(bodyClass, responseWrapper);
                return (T)object;
            }
            UnknownContentTypeException unknownContentTypeException = new UnknownContentTypeException(bodyType, contentType, responseWrapper.getStatusCode(), responseWrapper.getStatusText(), responseWrapper.getHeaders(), RestClientUtils.getBody(responseWrapper));
            if (observation == null) throw unknownContentTypeException;
            observation.error((Throwable)((Object)unknownContentTypeException));
            throw unknownContentTypeException;
        }
        catch (IOException | UncheckedIOException | HttpMessageNotReadableException exc) {
            Object cause;
            if (exc instanceof UncheckedIOException) {
                UncheckedIOException uncheckedIOException = (UncheckedIOException)exc;
                cause = uncheckedIOException.getCause();
            } else {
                cause = exc;
            }
            RestClientException restClientException = new RestClientException("Error while extracting response for type [" + ResolvableType.forType((Type)bodyType) + "] and content type [" + contentType + "]", (Throwable)cause);
            if (observation == null) throw restClientException;
            observation.error((Throwable)((Object)restClientException));
            observation.stop();
            throw restClientException;
        }
        catch (RestClientException restClientException) {
            if (observation == null) throw restClientException;
            observation.error((Throwable)((Object)restClientException));
            observation.stop();
            throw restClientException;
        }
    }

    private static MediaType getContentType(ClientHttpResponse clientResponse) {
        MediaType contentType = clientResponse.getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return contentType;
    }

    private static <T> Class<T> bodyClass(Type type) {
        ParameterizedType parameterizedType;
        Type type2;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType && (type2 = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class rawType = (Class)type2;
            return rawType;
        }
        return Object.class;
    }

    private class DefaultRequestBodyUriSpec
    implements RestClient.RequestBodyUriSpec {
        private final HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private InternalBody body;
        @Nullable
        private Map<String, Object> attributes;
        @Nullable
        private Consumer<ClientHttpRequest> httpRequestConsumer;

        public DefaultRequestBodyUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public RestClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(DefaultRestClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public RestClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(DefaultRestClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public RestClient.RequestBodySpec uri(String uriTemplate, Function<UriBuilder, URI> uriFunction) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(uriFunction.apply(DefaultRestClient.this.uriBuilderFactory.uriString(uriTemplate)));
        }

        @Override
        public RestClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultRestClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public RestClient.RequestBodySpec uri(URI uri) {
            if (uri.isAbsolute()) {
                this.uri = uri;
            } else {
                URI baseUri = DefaultRestClient.this.uriBuilderFactory.expand("", new Object[0]);
                this.uri = baseUri.resolve(uri);
            }
            return this;
        }

        private HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
            }
            return this.headers;
        }

        @Override
        public DefaultRequestBodyUriSpec header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec headers(Consumer<HttpHeaders> headersConsumer) {
            headersConsumer.accept(this.getHeaders());
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec accept(MediaType ... acceptableMediaTypes) {
            this.getHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec acceptCharset(Charset ... acceptableCharsets) {
            this.getHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentType(MediaType contentType) {
            this.getHeaders().setContentType(contentType);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentLength(long contentLength) {
            this.getHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.getHeaders().setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifNoneMatch(String ... ifNoneMatches) {
            this.getHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public RestClient.RequestBodySpec attribute(String name, Object value) {
            this.getAttributes().put(name, value);
            return this;
        }

        @Override
        public RestClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.getAttributes());
            return this;
        }

        private Map<String, Object> getAttributes() {
            Map<String, Object> attributes = this.attributes;
            if (attributes == null) {
                this.attributes = attributes = new ConcurrentHashMap<String, Object>(4);
            }
            return attributes;
        }

        @Override
        public RestClient.RequestBodySpec httpRequest(Consumer<ClientHttpRequest> requestConsumer) {
            this.httpRequestConsumer = this.httpRequestConsumer != null ? this.httpRequestConsumer.andThen(requestConsumer) : requestConsumer;
            return this;
        }

        @Override
        public RestClient.RequestBodySpec body(Object body2) {
            this.body = clientHttpRequest -> this.writeWithMessageConverters(body2, body2.getClass(), clientHttpRequest);
            return this;
        }

        @Override
        public <T> RestClient.RequestBodySpec body(T body2, ParameterizedTypeReference<T> bodyType) {
            this.body = clientHttpRequest -> this.writeWithMessageConverters(body2, bodyType.getType(), clientHttpRequest);
            return this;
        }

        @Override
        public RestClient.RequestBodySpec body(StreamingHttpOutputMessage.Body body2) {
            this.body = request -> body2.writeTo(request.getBody());
            return this;
        }

        private void writeWithMessageConverters(Object body2, Type bodyType, ClientHttpRequest clientRequest) throws IOException {
            MediaType contentType = clientRequest.getHeaders().getContentType();
            Class<?> bodyClass = body2.getClass();
            for (HttpMessageConverter<?> messageConverter : DefaultRestClient.this.messageConverters) {
                if (messageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)messageConverter;
                    if (!genericMessageConverter.canWrite(bodyType, bodyClass, contentType)) continue;
                    this.logBody(body2, contentType, genericMessageConverter);
                    genericMessageConverter.write(body2, bodyType, contentType, clientRequest);
                    return;
                }
                if (messageConverter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartMessageConverter = (SmartHttpMessageConverter)messageConverter;
                    ResolvableType resolvableType = ResolvableType.forType((Type)bodyType);
                    if (!smartMessageConverter.canWrite(resolvableType, bodyClass, contentType)) continue;
                    this.logBody(body2, contentType, smartMessageConverter);
                    smartMessageConverter.write(body2, resolvableType, contentType, clientRequest, null);
                    return;
                }
                if (!messageConverter.canWrite(bodyClass, contentType)) continue;
                this.logBody(body2, contentType, messageConverter);
                messageConverter.write(body2, contentType, clientRequest);
                return;
            }
            String message = "No HttpMessageConverter for " + bodyClass.getName();
            if (contentType != null) {
                message = message + " and content type \"" + contentType + "\"";
            }
            throw new RestClientException(message);
        }

        private void logBody(Object body2, @Nullable MediaType mediaType, HttpMessageConverter<?> converter) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder("Writing [");
                msg.append(body2);
                msg.append("] ");
                if (mediaType != null) {
                    msg.append("as \"");
                    msg.append(mediaType);
                    msg.append("\" ");
                }
                msg.append("with ");
                msg.append(converter.getClass().getName());
                logger.debug((Object)msg.toString());
            }
        }

        @Override
        public RestClient.ResponseSpec retrieve() {
            return this.exchangeInternal((x$0, x$1) -> new DefaultResponseSpec(x$0, x$1), false);
        }

        @Override
        public <T> T exchange(RestClient.RequestHeadersSpec.ExchangeFunction<T> exchangeFunction, boolean close) {
            return this.exchangeInternal(exchangeFunction, close);
        }

        private <T> T exchangeInternal(RestClient.RequestHeadersSpec.ExchangeFunction<T> exchangeFunction, boolean close) {
            Assert.notNull(exchangeFunction, (String)"ExchangeFunction must not be null");
            ClientHttpResponse clientResponse = null;
            Observation observation = null;
            URI uri = null;
            try {
                uri = this.initUri();
                HttpHeaders headers = this.initHeaders();
                ClientHttpRequest clientRequest = this.createRequest(uri);
                clientRequest.getHeaders().addAll(headers);
                Map<String, Object> attributes = this.getAttributes();
                clientRequest.getAttributes().putAll(attributes);
                ClientRequestObservationContext observationContext = new ClientRequestObservationContext(clientRequest);
                observationContext.setUriTemplate((String)attributes.get(URI_TEMPLATE_ATTRIBUTE));
                observation = ClientHttpObservationDocumentation.HTTP_CLIENT_EXCHANGES.observation(DefaultRestClient.this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, DefaultRestClient.this.observationRegistry).start();
                if (this.body != null) {
                    this.body.writeTo(clientRequest);
                }
                if (this.httpRequestConsumer != null) {
                    this.httpRequestConsumer.accept(clientRequest);
                }
                clientResponse = clientRequest.execute();
                observationContext.setResponse(clientResponse);
                DefaultConvertibleClientHttpResponse convertibleWrapper = new DefaultConvertibleClientHttpResponse(clientResponse, observation);
                T t = exchangeFunction.exchange(clientRequest, convertibleWrapper);
                return t;
            }
            catch (IOException ex) {
                ResourceAccessException resourceAccessException = DefaultRequestBodyUriSpec.createResourceAccessException(uri, this.httpMethod, ex);
                if (observation != null) {
                    observation.error((Throwable)((Object)resourceAccessException));
                    observation.stop();
                }
                throw resourceAccessException;
            }
            catch (Throwable error) {
                if (observation != null) {
                    observation.error(error);
                    observation.stop();
                }
                throw error;
            }
            finally {
                if (close && clientResponse != null) {
                    clientResponse.close();
                    if (observation != null) {
                        observation.stop();
                    }
                }
            }
        }

        private URI initUri() {
            return this.uri != null ? this.uri : DefaultRestClient.this.uriBuilderFactory.expand("", new Object[0]);
        }

        private HttpHeaders initHeaders() {
            HttpHeaders defaultHeaders = DefaultRestClient.this.defaultHeaders;
            if (CollectionUtils.isEmpty((Map)((Object)this.headers))) {
                return defaultHeaders != null ? defaultHeaders : new HttpHeaders();
            }
            if (CollectionUtils.isEmpty((Map)((Object)defaultHeaders))) {
                return this.headers;
            }
            HttpHeaders result = new HttpHeaders();
            result.putAll((Map<? extends String, ? extends List<String>>)((Object)defaultHeaders));
            result.putAll((Map<? extends String, ? extends List<String>>)((Object)this.headers));
            return result;
        }

        private ClientHttpRequest createRequest(URI uri) throws IOException {
            ClientHttpRequestFactory factory;
            if (DefaultRestClient.this.interceptors != null) {
                factory = DefaultRestClient.this.interceptingRequestFactory;
                if (factory == null) {
                    DefaultRestClient.this.interceptingRequestFactory = factory = new InterceptingClientHttpRequestFactory(DefaultRestClient.this.clientRequestFactory, DefaultRestClient.this.interceptors);
                }
            } else {
                factory = DefaultRestClient.this.clientRequestFactory;
            }
            ClientHttpRequest request = factory.createRequest(uri, this.httpMethod);
            if (DefaultRestClient.this.initializers != null) {
                DefaultRestClient.this.initializers.forEach(initializer -> initializer.initialize(request));
            }
            return request;
        }

        private static ResourceAccessException createResourceAccessException(URI url, HttpMethod method, IOException ex) {
            StringBuilder msg = new StringBuilder("I/O error on ");
            msg.append(method.name());
            msg.append(" request for \"");
            String urlString = url.toString();
            int idx = urlString.indexOf(63);
            if (idx != -1) {
                msg.append(urlString, 0, idx);
            } else {
                msg.append(urlString);
            }
            msg.append("\": ");
            msg.append(ex.getMessage());
            return new ResourceAccessException(msg.toString(), ex);
        }

        @FunctionalInterface
        private static interface InternalBody {
            public void writeTo(ClientHttpRequest var1) throws IOException;
        }
    }

    private class DefaultConvertibleClientHttpResponse
    implements RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse {
        private final ClientHttpResponse delegate;
        private final Observation observation;

        public DefaultConvertibleClientHttpResponse(ClientHttpResponse delegate, Observation observation) {
            this.delegate = delegate;
            this.observation = observation;
        }

        @Override
        @Nullable
        public <T> T bodyTo(Class<T> bodyType) {
            return DefaultRestClient.this.readWithMessageConverters(this.delegate, () -> {}, bodyType, bodyType, this.observation);
        }

        @Override
        @Nullable
        public <T> T bodyTo(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return DefaultRestClient.this.readWithMessageConverters(this.delegate, () -> {}, type, bodyClass, this.observation);
        }

        @Override
        public InputStream getBody() throws IOException {
            return this.delegate.getBody();
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        @Override
        public HttpStatusCode getStatusCode() throws IOException {
            return this.delegate.getStatusCode();
        }

        @Override
        public String getStatusText() throws IOException {
            return this.delegate.getStatusText();
        }

        @Override
        public void close() {
            this.delegate.close();
            this.observation.stop();
        }
    }

    private class DefaultResponseSpec
    implements RestClient.ResponseSpec {
        private final HttpRequest clientRequest;
        private final ClientHttpResponse clientResponse;
        private final List<StatusHandler> statusHandlers = new ArrayList<StatusHandler>(1);
        private final int defaultStatusHandlerCount;

        DefaultResponseSpec(HttpRequest clientRequest, ClientHttpResponse clientResponse) {
            this.clientRequest = clientRequest;
            this.clientResponse = clientResponse;
            this.statusHandlers.addAll(DefaultRestClient.this.defaultStatusHandlers);
            this.statusHandlers.add(StatusHandler.defaultHandler(DefaultRestClient.this.messageConverters));
            this.defaultStatusHandlerCount = this.statusHandlers.size();
        }

        @Override
        public RestClient.ResponseSpec onStatus(Predicate<HttpStatusCode> statusPredicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
            Assert.notNull(statusPredicate, (String)"StatusPredicate must not be null");
            Assert.notNull((Object)errorHandler, (String)"ErrorHandler must not be null");
            return this.onStatusInternal(StatusHandler.of(statusPredicate, errorHandler));
        }

        @Override
        public RestClient.ResponseSpec onStatus(ResponseErrorHandler errorHandler) {
            Assert.notNull((Object)errorHandler, (String)"ResponseErrorHandler must not be null");
            return this.onStatusInternal(StatusHandler.fromErrorHandler(errorHandler));
        }

        private RestClient.ResponseSpec onStatusInternal(StatusHandler statusHandler) {
            Assert.notNull((Object)statusHandler, (String)"StatusHandler must not be null");
            int index = this.statusHandlers.size() - this.defaultStatusHandlerCount;
            this.statusHandlers.add(index, statusHandler);
            return this;
        }

        @Override
        @Nullable
        public <T> T body(Class<T> bodyType) {
            return this.readBody(bodyType, bodyType);
        }

        @Override
        @Nullable
        public <T> T body(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return this.readBody(type, bodyClass);
        }

        @Override
        public <T> ResponseEntity<T> toEntity(Class<T> bodyType) {
            return this.toEntityInternal(bodyType, bodyType);
        }

        @Override
        public <T> ResponseEntity<T> toEntity(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return this.toEntityInternal(type, bodyClass);
        }

        private <T> ResponseEntity<T> toEntityInternal(Type bodyType, Class<T> bodyClass) {
            T body2 = this.readBody(bodyType, bodyClass);
            try {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status(this.clientResponse.getStatusCode()).headers(this.clientResponse.getHeaders())).body(body2);
            }
            catch (IOException ex) {
                throw new ResourceAccessException("Could not retrieve response status code: " + ex.getMessage(), ex);
            }
        }

        @Override
        public ResponseEntity<Void> toBodilessEntity() {
            ClientHttpResponse clientHttpResponse = this.clientResponse;
            try {
                this.applyStatusHandlers();
                ResponseEntity<Void> responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status(this.clientResponse.getStatusCode()).headers(this.clientResponse.getHeaders())).build();
                if (clientHttpResponse != null) {
                    clientHttpResponse.close();
                }
                return responseEntity;
            }
            catch (Throwable throwable) {
                try {
                    if (clientHttpResponse != null) {
                        try {
                            clientHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException ex) {
                    throw new ResourceAccessException("Could not retrieve response status code: " + ex.getMessage(), ex.getCause());
                }
                catch (IOException ex) {
                    throw new ResourceAccessException("Could not retrieve response status code: " + ex.getMessage(), ex);
                }
            }
        }

        @Nullable
        private <T> T readBody(Type bodyType, Class<T> bodyClass) {
            return DefaultRestClient.this.readWithMessageConverters(this.clientResponse, this::applyStatusHandlers, bodyType, bodyClass, this.getCurrentObservation());
        }

        private void applyStatusHandlers() {
            try {
                ClientHttpResponse response = this.clientResponse;
                if (response instanceof DefaultConvertibleClientHttpResponse) {
                    DefaultConvertibleClientHttpResponse convertibleResponse = (DefaultConvertibleClientHttpResponse)response;
                    response = convertibleResponse.delegate;
                }
                for (StatusHandler handler : this.statusHandlers) {
                    if (!handler.test(response)) continue;
                    handler.handle(this.clientRequest, response);
                    return;
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Nullable
        private Observation getCurrentObservation() {
            ClientHttpResponse clientHttpResponse = this.clientResponse;
            if (clientHttpResponse instanceof DefaultConvertibleClientHttpResponse) {
                DefaultConvertibleClientHttpResponse convertibleResponse = (DefaultConvertibleClientHttpResponse)clientHttpResponse;
                return convertibleResponse.observation;
            }
            return null;
        }
    }
}

