/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class UrlHandlerFilter
extends OncePerRequestFilter {
    private static final Log logger = LogFactory.getLog(UrlHandlerFilter.class);
    private final Map<PathPattern, Handler> handlers;

    private UrlHandlerFilter(Map<PathPattern, Handler> handlers) {
        this.handlers = new LinkedHashMap<PathPattern, Handler>(handlers);
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        RequestPath previousPath;
        RequestPath path = previousPath = (RequestPath)request.getAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
        try {
            if (path == null) {
                path = ServletRequestPathUtils.parseAndCache(request);
            }
            for (Map.Entry<PathPattern, Handler> entry : this.handlers.entrySet()) {
                Handler handler = entry.getValue();
                if (!entry.getKey().matches(path) || !handler.shouldHandle(request)) continue;
                handler.handle(request, response, chain);
                return;
            }
        }
        finally {
            if (previousPath != null) {
                ServletRequestPathUtils.setParsedRequestPath(previousPath, (ServletRequest)request);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static TrailingSlashHandlerSpec trimTrailingSlash(String ... pathPatterns) {
        return new DefaultBuilder().trimTrailingSlash(pathPatterns);
    }

    private static interface Handler {
        public boolean shouldHandle(HttpServletRequest var1);

        public void handle(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final PathPatternParser patternParser = new PathPatternParser();
        private final Map<PathPattern, Handler> handlers = new LinkedHashMap<PathPattern, Handler>();

        private DefaultBuilder() {
        }

        @Override
        public TrailingSlashHandlerSpec trimTrailingSlash(String ... pathPatterns) {
            return new DefaultTrailingSlashHandlerSpec(this, this.parseTrailingSlashPatterns(pathPatterns));
        }

        public void addHandler(List<PathPattern> pathPatterns, Handler handler) {
            for (PathPattern pattern : pathPatterns) {
                this.handlers.put(pattern, handler);
            }
        }

        /*
         * WARNING - void declaration
         */
        private List<PathPattern> parseTrailingSlashPatterns(String ... patternValues) {
            ArrayList<PathPattern> patterns = new ArrayList<PathPattern>(patternValues.length);
            for (String string : patternValues) {
                void var6_6;
                if (!string.endsWith("**") && string.charAt(string.length() - 1) != '/') {
                    String string2 = string + "/";
                }
                patterns.add(this.patternParser.parse((String)var6_6));
            }
            return patterns;
        }

        @Override
        public UrlHandlerFilter build() {
            return new UrlHandlerFilter(this.handlers);
        }
    }

    public static interface TrailingSlashHandlerSpec {
        public TrailingSlashHandlerSpec intercept(Consumer<HttpServletRequest> var1);

        public Builder andRedirect(HttpStatus var1);

        public Builder andHandleRequest();
    }

    private static class PathHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final String requestURI;
        private final StringBuffer requestURL;
        private final String servletPath;
        private final String pathInfo;

        PathHttpServletRequestWrapper(HttpServletRequest request, Function<String, String> pathFunction) {
            super(request);
            this.requestURI = pathFunction.apply(request.getRequestURI());
            this.requestURL = new StringBuffer(pathFunction.apply(request.getRequestURL().toString()));
            if (StringUtils.hasText((String)request.getPathInfo())) {
                this.servletPath = request.getServletPath();
                this.pathInfo = pathFunction.apply(request.getPathInfo());
            } else {
                this.servletPath = pathFunction.apply(request.getServletPath());
                this.pathInfo = request.getPathInfo();
            }
        }

        public String getRequestURI() {
            return this.requestURI;
        }

        public StringBuffer getRequestURL() {
            return this.requestURL;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }
    }

    private static final class RequestWrappingPathHandler
    extends AbstractPathHandler {
        RequestWrappingPathHandler(Predicate<HttpServletRequest> pathPredicate, Function<String, String> pathFunction, Consumer<HttpServletRequest> interceptor) {
            super(pathPredicate, pathFunction, interceptor);
        }

        @Override
        public void handleInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
            request = new PathHttpServletRequestWrapper((HttpServletRequest)request, this.getPathFunction());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static final class RedirectPathHandler
    extends AbstractPathHandler {
        private final HttpStatus httpStatus;

        RedirectPathHandler(Predicate<HttpServletRequest> pathPredicate, Function<String, String> pathFunction, HttpStatus httpStatus, Consumer<HttpServletRequest> interceptor) {
            super(pathPredicate, pathFunction, interceptor);
            this.httpStatus = httpStatus;
        }

        @Override
        public void handleInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
            String location = this.getPathFunction().apply(request.getRequestURI());
            response.resetBuffer();
            response.setStatus(this.httpStatus.value());
            response.setHeader("Location", location);
            response.flushBuffer();
        }
    }

    private static abstract class AbstractPathHandler
    implements Handler {
        private final Predicate<HttpServletRequest> pathPredicate;
        private final Function<String, String> pathFunction;
        private final Consumer<HttpServletRequest> interceptor;

        AbstractPathHandler(Predicate<HttpServletRequest> pathPredicate, Function<String, String> pathFunction, Consumer<HttpServletRequest> interceptor) {
            this.pathPredicate = pathPredicate;
            this.pathFunction = pathFunction;
            this.interceptor = interceptor;
        }

        protected Function<String, String> getPathFunction() {
            return this.pathFunction;
        }

        @Override
        public boolean shouldHandle(HttpServletRequest request) {
            return this.pathPredicate.test(request);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
            this.interceptor.accept(request);
            this.handleInternal(request, response, chain);
        }

        protected abstract void handleInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;
    }

    private static final class DefaultTrailingSlashHandlerSpec
    implements TrailingSlashHandlerSpec {
        private static final Predicate<HttpServletRequest> trailingSlashPredicate = request -> request.getRequestURI().endsWith("/");
        private static final Function<String, String> trimTralingSlashFunction = path -> {
            int index = StringUtils.hasLength((String)path) ? path.lastIndexOf(47) : -1;
            return index != -1 ? path.substring(0, index) : path;
        };
        private final DefaultBuilder parent;
        private final List<PathPattern> pathPatterns;
        @Nullable
        private Consumer<HttpServletRequest> interceptors;

        private DefaultTrailingSlashHandlerSpec(DefaultBuilder parent, List<PathPattern> pathPatterns) {
            this.parent = parent;
            this.pathPatterns = pathPatterns;
        }

        @Override
        public TrailingSlashHandlerSpec intercept(Consumer<HttpServletRequest> interceptor) {
            this.interceptors = this.interceptors != null ? this.interceptors.andThen(interceptor) : interceptor;
            return this;
        }

        @Override
        public Builder andRedirect(HttpStatus status) {
            return this.addHandler(new RedirectPathHandler(trailingSlashPredicate, trimTralingSlashFunction, status, this.initInterceptor()));
        }

        @Override
        public Builder andHandleRequest() {
            return this.addHandler(new RequestWrappingPathHandler(trailingSlashPredicate, trimTralingSlashFunction, this.initInterceptor()));
        }

        private Consumer<HttpServletRequest> initInterceptor() {
            if (this.interceptors != null) {
                return this.interceptors;
            }
            return request -> {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Trimmed trailing slash: " + request.getMethod() + " " + request.getRequestURI()));
                }
            };
        }

        private DefaultBuilder addHandler(Handler handler) {
            this.parent.addHandler(this.pathPatterns, handler);
            return this.parent;
        }
    }

    public static interface Builder {
        public TrailingSlashHandlerSpec trimTrailingSlash(String ... var1);

        public UrlHandlerFilter build();
    }
}

