/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ReactorNettyClientRequest;
import org.springframework.util.Assert;
import reactor.netty.http.client.HttpClient;

public class ReactorNettyClientRequestFactory
implements ClientHttpRequestFactory {
    private final HttpClient httpClient;
    private Duration exchangeTimeout = Duration.ofSeconds(5L);
    private Duration readTimeout = Duration.ofSeconds(10L);

    public ReactorNettyClientRequestFactory() {
        this(HttpClient.create().compress(true));
    }

    public ReactorNettyClientRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setConnectTimeout(int connectTimeout) {
        Assert.isTrue((connectTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
    }

    public void setConnectTimeout(Duration connectTimeout) {
        Assert.notNull((Object)connectTimeout, (String)"ConnectTimeout must not be null");
        Assert.isTrue((!connectTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeout.toMillis()));
    }

    public void setReadTimeout(long readTimeout) {
        Assert.isTrue((readTimeout > 0L ? 1 : 0) != 0, (String)"Timeout must be a positive value");
        this.readTimeout = Duration.ofMillis(readTimeout);
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, (String)"ReadTimeout must not be null");
        Assert.isTrue((!readTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.readTimeout = readTimeout;
    }

    public void setExchangeTimeout(long exchangeTimeout) {
        Assert.isTrue((exchangeTimeout > 0L ? 1 : 0) != 0, (String)"Timeout must be a positive value");
        this.exchangeTimeout = Duration.ofMillis(exchangeTimeout);
    }

    public void setExchangeTimeout(Duration exchangeTimeout) {
        Assert.notNull((Object)exchangeTimeout, (String)"ExchangeTimeout must not be null");
        Assert.isTrue((!exchangeTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.exchangeTimeout = exchangeTimeout;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new ReactorNettyClientRequest(this.httpClient, uri, httpMethod, this.exchangeTimeout, this.readTimeout);
    }
}

