/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.springframework.context.MessageSource;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.ErrorResponse;

public class MethodArgumentNotValidException
extends BindException
implements ErrorResponse {
    private final MethodParameter parameter;
    private final ProblemDetail body;

    public MethodArgumentNotValidException(MethodParameter parameter, BindingResult bindingResult) {
        super(bindingResult);
        this.parameter = parameter;
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), "Invalid request content.");
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Validation failed for argument [").append(this.parameter.getParameterIndex()).append("] in ").append(this.parameter.getExecutable().toGenericString());
        BindingResult bindingResult = this.getBindingResult();
        if (bindingResult.getErrorCount() > 1) {
            sb.append(" with ").append(bindingResult.getErrorCount()).append(" errors");
        }
        sb.append(": ");
        for (ObjectError error : bindingResult.getAllErrors()) {
            sb.append('[').append(error).append("] ");
        }
        return sb.toString();
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{MethodArgumentNotValidException.errorsToStringList(this.getBindingResult().getGlobalErrors()), MethodArgumentNotValidException.errorsToStringList(this.getBindingResult().getFieldErrors())};
    }

    @Override
    public Object[] getDetailMessageArguments(MessageSource messageSource, Locale locale) {
        return new Object[]{MethodArgumentNotValidException.errorsToStringList(this.getBindingResult().getGlobalErrors(), messageSource, locale), MethodArgumentNotValidException.errorsToStringList(this.getBindingResult().getFieldErrors(), messageSource, locale)};
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors) {
        return MethodArgumentNotValidException.errorsToStringList(errors, error -> error.getDefaultMessage() != null ? error.getDefaultMessage() : error.getCode());
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors, MessageSource source, Locale locale) {
        return MethodArgumentNotValidException.errorsToStringList(errors, error -> source.getMessage(error.getCode(), error.getArguments(), error.getDefaultMessage(), locale));
    }

    private static List<String> errorsToStringList(List<? extends ObjectError> errors, Function<ObjectError, String> formatter) {
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (ObjectError objectError : errors) {
            String string;
            String value = formatter.apply(objectError);
            if (!StringUtils.hasText((String)value)) continue;
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                string = fieldError.getField() + ": '" + value + "'";
            } else {
                string = "'" + value + "'";
            }
            result.add(string);
        }
        return result;
    }
}

